function ParSeqShExe(S,ExeK,ResRoot,KaldiTrunkRoot,ExOptF,ExMach,AsrResRoot,JHome)
%Parallel Sequential Shell Execution


%
nj=length(S); %number of jobs
QSubDir=[ResRoot '/QSubDir'];

JobC=cell(nj,1);


resources='core=1'; %cpu=1 %core is the basic, a cpu can have several cores
%resources='cpu=4'; %cpu=1
%walltime='95'; %4 days
walltime='23';  %2 weeks
%walltime='00:15:00';



for i=1:nj
    
   P=S(i);
   
   JDir=[QSubDir '/' P.JId]; 
   MkJDir=['mkdir -p ' JDir];
   
   %Launcher=['qsub -N ' P.JName ' -wd ' QSubDir ' -l h_vmem={' P.JMemMa '} -j y -o ' JDir '/StOE.txt -hold_jid ' P.JWait];
   
   StO=[JDir '/StO.txt'];
   RmSt=['rm -rf ' StO]; 
   
   
   switch ExMach
       
       case 'ALH'
           Launcher=['qsub -q ' 'NOParalela' ' -N ' P.JName ' -j y -o ' StO ' '];
           
           
       otherwise
           Launcher=['oarsub -q production -p "cluster=''talc''" -l ' resources ',walltime=' walltime ' -n ' P.JName ' --stdout=' StO ' --stderr=' StO ' -S'];
           %Launcher=['oarsub -q production -p "cluster=''graphique''" -l ' resources ',walltime=' walltime ' -n ' P.JName ' --stdout=' StO ' --stderr=' StO ' -S'];
           % Launcher=['oarsub -l ' resources ',walltime=' walltime ' -n ' P.JName ' --stdout=' StO ' --stderr=' StO ' -S'];
           %Launcher=['oarsub -t besteffort -l ' resources ',walltime=' walltime ' -n ' P.JName ' --stdout=' StO ' --stderr=' StO ' -S'];
           %-t besteffort. If besteffort all the 800 jobs are executed in parallel, else only 350 jobs
           % -p "GPU=''NO''"
           % -q production -p "cluster=''talc''"
           
           
           
           
   end
   
  
     
   
   switch ExeK
       
       case {'p', 'pc'}
           c1=[MkJDir '; ' RmSt '; ' Launcher];
           
           if strcmp(ExMach,'ALH')
               c=[c1 ' ' P.ShC ''];   
           else
               c=[c1 ' "' P.ShC '"'];      
           end
             
           
           
           
       case 's'
           c=[P.ShC];
           
       case 'e'
           c=StO;           
   end   
   
   
   
   
   JobC{i}=c;  
   
   
    
end

%Juan To Grid Paths
UName=S.UName;
McrRoot=S.McrRoot;
[JobC,GHomeSyn]=Juan2GridPathJobC(JobC,ExeK,AsrResRoot,JHome,UName,McrRoot,KaldiTrunkRoot,ExMach);

%
switch ExeK
    case 'e'
        PrintStEO(JobC);
    case {'s','p'}   
        %Wr AllJobSh
        AllJob=[AsrResRoot '/AllJob.sh'];
        WrAllJobSh(AllJob,JobC);         
        %RSync
        RSyncGridPr(AllJob,GHomeSyn,ExMach);
        RSyncGridPr(ExOptF,GHomeSyn,ExMach); %just to syncronize execution extra options
        
        
    case 'pc'        
        %Wr AllJobSh
        AllJob=[AsrResRoot '/AllJob.jdl'];
        WrAllJobJSonCamp(AllJob,JobC);
        %RSync
        RSyncGridPr(AllJob,GHomeSyn,ExMach);
        RSyncGridPr(ExOptF,GHomeSyn,ExMach); %just to syncronize execution extra options
       
        

end


