#!/bin/csh
#
# Universal Parallel-Sequential Executer of scripts (for qsub systems) 
#
# $C[1]: Job name
# $C[2]: Vector length of the jobs to wait  
# $C[3]: Jobs to wait vector (-1 means not wait)
# $C[#]: Job memory (-1 means default, 2G)
# $C[#+1:end]: Script to exec
# 


set F = $1	# Scripts File with ssh commands to launch 
set EX = $2 	# EXecution kind: s (sequential), p (paralell), e (errors read in Standard Ouputs and Errors)
set RESDIR = $3 # Result Dir where QSUB (StOE) is written (/clusterFS/home/user/jamc/RESULTS)


alias ShowLine 'head -n \!:1  \!:2 | tail -n 1' 


#
set QSubDir = $RESDIR/QSUBLOGDIR; 
set AllStOE = $QSubDir/AllStOE.txt
  
if (! -d $QSubDir) then
  mkdir -p $QSubDir;
  echo "WARNING: Created WorkingDir $QSubDir"
  echo "Sync and asleep for a while (15 sec) for WorkingDir detection by all hosts."
  echo "It is advisable to delete (qdel) all jobs and create manually the WorkingDir."
  sync; sleep 15;  echo "Awake after a while"
endif

#
rm -f $AllStOE
set NLI = `wc -l $F`
set JobSeqN = `seq 1 1 $NLI[1]`

foreach i ($JobSeqN)	
	
	# Command line to analyze   
	set C = `ShowLine $i $F`

	# Job Name
	set JobN = $C[1]	

	# Job Names to Wait separated by comma (dependence control)
	set iw = 3; set fw = `expr $C[2] + 2` 
	set JobW = '';  set aux = `seq $iw 1 $fw`
	foreach j ($aux)
	  if ($C[$j] != -1) then
	    if ($j != $aux[$#aux]) then
	      set JobW = `echo $JobW$C[$j],` 
	    else
	      set JobW = `echo $JobW$C[$j]`
	    endif
	  endif	
	 end

	# Job Memory
	set iw = `expr $C[2] + 3`; 
	set JobM = `echo $C[$iw]` 
	if ($JobM == -1) then
	    set JobM = 2G	
	endif

	  

		 
	# Job Script to execute	
	set iw = `expr $C[2] + 4`; set fw = $#C  
	set JobS = '';  
	foreach j (`seq $iw 1 $fw`)
	  set JobS = `echo $JobS $C[$j]` 
	end  
    
	# Job Identity and Dir 
	set JobI = `echo  {$JobN}{$JobS[3]}_{$i} | sed "s/\//\_/g"`
	set JobD = $QSubDir/$JobI

	
	# Job Option (wait or not)
	set JobO = "-N $JobN -wd $QSubDir -l h_vmem={$JobM} -j y -o $JobD/StOE.txt" 
	if ($JobW[1] != '') then	
		set JobO = `echo "$JobO -hold_jid $JobW"`
	endif	


	
	# Launch parallely, sequentially or show StOE.txt 
	if ($EX == p) then # For parallel job excution	
	  rm -rf $JobD; mkdir $JobD; 
	  sync; qsub $JobO $JobS $JobI	  

	else if ($EX == s) then # For sequentially job excution
	  rm -rf $JobD; mkdir $JobD; 
	  $JobS $JobI	    
	  


	else if ($EX == e) then # To see Job StOE.txt and analyze errors
	  echo "*************** StOE of $JobD/StOE.txt *******************" >> $AllStOE 
	  if( ! -e $JobD/StOE.txt ) then
	     echo "ERROR: $JobD/StOE.txt does not exist" >> $AllStOE
	     echo "ERROR: $JobD/StOE.txt does not exist" 
	  else
	    cat $JobD/StOE.txt >> $AllStOE 
	    echo "StOE of Job$i copied in $AllStOE"	
	  endif	  

	else
	  echo "ERROR: Unknown option $EX (for ParSeqExe.sh)"
	endif


end




