function [JobCO,GHomeSyn]=Juan2GridPathJobC(JobC,ExeK,JAsrResRoot,JHome,UName,McrRoot,KaldiTrunkRoot,ExMach)
%Juan To Grid Paths of Job Cell
%GHomeSyn: folder that local see. not the same as GHomeV. 



switch ExMach
        
    case 'GRID'  
        
        GHomeSyn='/home/jmoralescordovilla/nancy/Grid5000';   %for global
        %GHomeSyn='/home/jmoralescordovilla/Grid5000'; %for local-nancy
     
        switch ExeK %
            case {'s','p','pc'} %To execute in Grid
                GHomeV='/home/jmoralescordovilla/Grid5000'; 
                
                
                
            case {'e','r'} %To execute in Juan
                GHomeV=[JHome '/Mnt/Grid5000Home'];         
        end              
        GMcrRootV='/home/jmoralescordovilla/Grid5000/SpeechData/Softwares/MCR13a/v81';
        %GMcrRootV='/home/jmoralescordovilla/Grid5000/SpeechData/Softwares/MCR15a/v85';
        GKaldiTrunkRootV='/home/ssivasankaran/softwares/kaldi_nnet3_cpu';
        GUNameV='jmoralescordovilla';
        
   
        case 'ALH'          
        GHomeSyn='/home/TIC234/jamc';        
        switch ExeK %
            case {'s','p','pc'} %To execute in Grid
                GHomeV='/home/TIC234/jamc';                 
            case {'e','r'} %To execute in Juan
                GHomeV=[JHome '/Mnt/AlhTic234'];         
        end              
        GMcrRootV='/home/TIC234/jamc/SpeechData/Softwares/MCR13a/v81';
        GKaldiTrunkRootV='/home/TIC234/iloes/kaldi-trunk-r4710';
        GUNameV='jamc';    
        
        
        
    case 'LAPT'
        GHomeV=JHome;
        GMcrRootV=McrRoot;
        GKaldiTrunkRootV=KaldiTrunkRoot;
        GUNameV=UName;
        
    case 'GPU'
        GHomeV='/users/multispeech/jmorales/JMoralesLaptop';
        GMcrRootV='/local/logiciels/MathWorks/linux-R2015A';
        GKaldiTrunkRootV='/logiciels/kaldi-trunk-4710';
        GUNameV='jmorales';
        
end 



%
l=length(JobC);

JobCO=cell(l,1);
for i=1:l    
   c=JobC{i};
   %Subtitutions   (the order is important)
   c=strrep(c,KaldiTrunkRoot,GKaldiTrunkRootV);  
   c=strrep(c,JHome,GHomeV);
   c=strrep(c,McrRoot,GMcrRootV);
         
   c=strrep(c,[' ' UName ' '],[' ' GUNameV ' ']);

   JobCO{i}=c;
end





