#!/bin/bash

echo '**************************************'
echo "JobId: $OAR_FILE_NODES"
echo "Do oarstat -fj JobId"
echo '**************************************'


# Execute a Matlab binary Program

JId=$1 	#Job Id to create a unique folder in /tmp for matlab Re/Wr 
UName=$2	#User Name
McrRoot=$3 	#Mcr


#Matlab binary Program (rest of the bash input) (program + inputs)
MatPr=''
args=("$@") 
NI=${#args[@]} 
for (( i=3;i<$NI;i++)); do 
    MatPr=`echo $MatPr ${args[${i}]}`     
done


# Matlab Libraries
# When the FE program is compiled (mcc) -C option is not used so, by default, the CTF (Component Technology File) is embeded 
# in the FE. When a machine wants to execute the FE, first, the machine extracts (unziped) the CTF file in MCR_CACHE_ROOT 
# folder and then the FE is executed. For high running speed in the Grid, it is very important that MCR_CACHE_ROOT is 
# created in a local (/tmp/..) folder of the job-machine.
# MCR_CACHE_VERBOSE can be very helpful if problems are encountered during CTF archive 
# extraction.
export LD_LIBRARY_PATH=$McrRoot/runtime/glnxa64:$McrRoot/bin/glnxa64:$McrRoot/sys/os/glnxa64:
export XAPPLRESDIR=$McrRoot/X11/app-defaults
#
McrCacheDir=/tmp/$UName/$JId
mkdir -p $McrCacheDir;
export MCR_CACHE_ROOT=$McrCacheDir
# setenv MCR_CACHE_VERBOSE $McrCacheDir/Verbose 


# System Libraries (needed by Kaldi, the matlab libraries are not good)
export LD_PRELOAD=/usr/lib/x86_64-linux-gnu/libgfortran.so.3:/usr/lib/x86_64-linux-gnu/libstdc++.so.6:/usr/lib/liblapack_atlas.so.3

#Execute Matlab Program
echo "Executing $MatPr......"
$MatPr


rm -rf $McrCacheDir



