function RunExample
%Code for paper e.g.:
% Juan A. Morales-Cordovilla, Martin Hagmüller, Hannes Pessentheiner and Gernot Kubin. 
% "Distant speech recognition in reverberant noisy conditions employing a microphone array". 
% EUSIPCO. ISSN: 2219-5491. Lisbon, September, 2014.
%
%Create noisy embedded signals using clean no reverberated isolated signals (it needs FBK impulses
%responses and noises) 
%The final output is in NoisyEmbedRoot: the noisy embedded files (at  and the
%SNRs of P.SnrV) and the corresponding clean (noisy-clean=noise)

%Add paths
addpath('./Fun')
addpath('./Fun/Fbk2TUGraz')
addpath('./Fun/MicArray');


%Inputs paths
IsoRoot     ='/home/jmorales/SpeechData/CHIME3_All/Dev/Aux2';   %Isolate Root (with speech no reververated clean utterances)
IsoSubF     ='dt05_caf_simu_clean'; %Isolate SubFolder (usually with utterances of one speaker)
FbkIRRoot      ='/home/jmorales/SpeechData/FBKGEDIRHA_All/ITEA/IRs/mat'; %Fbk impulse responses (where we can find folders LA, LB, ..) 
%(here we do not use really FbkIRRoot because they have not yet realeased)
FbkNoiseIsoRoot ='/home/jmorales/SpeechData/FBKGEDIRHA_All/ITEA/Noises/dev1'; %Fbk Noise Isolate Root (to find isolated noises together with NFList)
NListF      ='./Fun/Fbk2TUGraz/NList2.txt'; %Noise File List


%Outputs paths
ORoot=[IsoRoot '/Aux']; %Output Root (to write all results)
CleanEmbedRoot=[ORoot '/CleanEmbed']; %Clean reverberated Embedded Root 
NoiseEmbedDir16kHz=[ORoot '/16kHzEmbedNoises']; %Noise Embedded Root
NoisyEmbedRoot=[ORoot '/NoisyEmbed']; %Noisy Embedded Root
[x,x,x]=mkdir(ORoot); %Create ORoot

%Parameters for EmbedClean (reverberated)
P.Ext='.wav'; %audio file extension
P.xsFSamp=16000; %output sample frequency (FBK files are at 48kHz but we work at 16kHz)
P.MiGSec=0.5; P.MaGSec=5; %Gaps In Seconds
P.IsolNEmb=8; %Isolated Numbers per Embbed (on average see partion function)
P.Pos={ 'BA' 'BB' 'BC' 'BD' 'BE' 'BF' 'BG' 'BH' 'BI' 'BL' ...
        'BM' 'BN' 'BO' 'BP' 'CA' 'CB' 'CC' 'KA' 'KB' 'KC' ...
        'KD' 'KE' 'KF' 'KG' 'KH' 'KI' 'KL' 'KM' 'KN' 'KO' ...
        'KP' 'KQ' 'KR' 'KS' 'KT' 'LA' 'LB' 'LC' 'LD' 'LE' ...
        'LF' 'LG' 'LH' 'LI' 'LL' 'LM' 'LN' 'LO' 'LP' 'LQ' ...
        'LR' 'LS' 'LT' 'RA' 'RB' 'RC' 'RD'}; %Posible Positions
P.Mic={'KA6' 'LA6' 'R1C' 'C1R' 'B2C'}; %Microphones that are in the output signal
P.FbkIRRoot=FbkIRRoot; %Fbk Inpulse Responses Root

%Parameters for EmbedNoisy
P.SnrV=[Inf 10 10 0 0];  %dBs. If vector then each noisy embedded file has some of these. If scalar use always this SNR value
%P.SnrV=[20];  %dBs. If vector then each noisy embedded file has some of these. If scalar use always this SNR value
P.SnrE=1.5; %dB 
P.PrevMSnr=5; %Previus Mixing SNR



%
%Clean reverberated embedded (use FBK impulses responses)
CrEmbedClean1Dir(CleanEmbedRoot,IsoRoot,IsoSubF,P); 
%Noise embedded (put together all FBK noises) 
EmbFbkNoises(NoiseEmbedDir16kHz,P.xsFSamp,FbkNoiseIsoRoot,NListF,P.Mic);    
%Noisy embeded at SNR indicated by P.SnrV
CrEmbedNoisy1Dir(NoisyEmbedRoot,CleanEmbedRoot,IsoSubF,NoiseEmbedDir16kHz,P) 


    









