function [xm,ns,FSamp]=ReFbkSigDir(DI,Mic)
%Read Fbk Signal Dir (for FBK the signals are directory)
%In standard order

%Select number microphones (default all of them)
R={'K1R' 'K1L' 'K2R' 'K2L' 'K3R' 'K3C' 'K3L' 'KA6' 'KA1' 'KA2' 'KA3' 'KA4' 'KA5' ...
'L1R' 'L1C' 'L1L' 'L2R' 'L2L' 'L3R' 'L3L' 'L4R' 'L4L' 'LA6' 'LA1' 'LA2' 'LA3' 'LA4' 'LA5' ... 
'C1R' 'C1L' ... 
'R1R' 'R1C' 'R1L' ... 
'B1R' 'B1L' 'B2R' 'B2C' 'B2L' 'B3R' 'B3L'};

switch nargin
    case 2
        R=Mic;
end



%    
a=[DI '/Kitchen/Wall/K1R.wav']; CpFIfNoExist(a);
[ch, FSamp]=audioread(a); 

ns=length(ch); nch=length(R); xm=zeros(ns,nch);

for i=1:nch
    M=R{i};
    switch M(1)
        case 'K'
            D1='Kitchen';
        case 'L'
            D1='Livingroom';
        case 'C'
            D1='Corridor';
        case 'R'
            D1='Bathroom';
        case 'B'
            D1='Bedroom'; 
    end    
    switch M(3)
        case {'R' 'C' 'L'}
            D2='Wall';
        case {'1' '2' '3' '4' '5' '6'}
            D2='Array';            
    end    
    
    
    a=[DI '/' D1 '/' D2 '/' M '.wav']; CpFIfNoExist(a);       
    [ch]=audioread(a);
    xm(:,i)=ch;    
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CpFIfNoExist(a)
%Copy  File (from FBK) If Not Exist
p='/afs/spsc.tugraz.at/resources/databases/DIRHA_FBK_sim/DIRHA_sim2/dev1';

if ~exist(a,'file')  
  a2=strrep(a, './Aux/dev1', p);    
  [pn,bn]=fileparts(a);
  system(['mkdir -p ' pn]);
  system(['cp ' a2 ' ' a]); 
  fprintf('WARNING: cp %s %s\n',a2,a);  
end

