function EmbFbkNoises(NoiseEmbedDir16kHz,OFSamp,FbkNoiseIsoRoot,NListF,Mic)
%Embed Fbk Noises in NoiseEmbedDir16kHz
%ORoot='/clusterFS/home/user/jamc/SPEECHDATA/FBKGEDIRHA_All/Aux';
%OFSamp=16000;
%


%We can choose between write when link lfn files or write when the link is
%bigger in samples than NSMa (see CrEmbedNoise)
lfn=18; %link file number
NSMa=180*OFSamp;

%
TmpISolNDir48kHz=[NoiseEmbedDir16kHz '/Tmp48kHzIsolNoises']; 
TmpISolNDir16kHz=[NoiseEmbedDir16kHz '/Tmp16kHzIsolNoises'];



%
CrIsolNoise(NListF,FbkNoiseIsoRoot,TmpISolNDir48kHz,Mic);
ReSampDir(TmpISolNDir48kHz,TmpISolNDir16kHz,OFSamp,'.wav');
CrEmbedNoise(TmpISolNDir16kHz,NoiseEmbedDir16kHz,lfn,NSMa);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CrEmbedNoise(NDir,EmbedNDir,lfn,NSMa)
%
%All 414 (23*18) files: 9.6743e+03 sec, 161.2383 min, 2.6873 hour 
%1 file average duration: 0.3895 min  
%18 files ave. durat: 7.0110 min

fy=dir([NDir '/*.wav']); 
l=size(fy,1); p=randperm(l);
j=1; k=0; tns=0; C={}; 
for i=1:l      
    
    k=k+1; 
    fn=[NDir '/' fy(p(i)).name];
    fprintf('%d(%d)/%d: %s (tns=%d/%d)\n',i,k,l,fn,tns,NSMa);
    [C{k}, fs]=audioread(fn);      
    [ns,nch]=size(C{k}); tns=tns+ns;
    
    
    %if ((mod(i,lfn)==0) || i==l)
    if (tns>NSMa || i==l)    
        CatWrCell(C,[EmbedNDir '/' num2str(j) '.wav'],fs);  j=j+1; k=0; tns=0; clear('C'); C={};    
    end
    
end

function CatWrCell(C,fn,fs)
%
%Compute need memory
l=length(C); ns=zeros(1,l);
for i=1:l;  [ns(i),nch]=size(C{i});  end; 
%Save in variable
tns=sum(ns); xa=zeros(tns,nch); ie=0;
for i=1:l
    ii=ie+1; ie=ii+ns(i)-1;   
    xa(ii:ie,:)=C{i};      
end
%Write
fprintf('Writting %s..',fn);
audiowrite(fn,xa,fs);
fprintf('written\n');
         
        


function CrIsolNoise(NListF,NRootS,NRootD,Mic)
%Create Noise Dir
[s,m,n] = rmdir(NRootD,'s'); mkdir(NRootD); 

A = importdata(NListF);

la=length(A);
for i=1:la
    dy=[NRootS '/' A{i}];          
    [p1, b1]=fileparts(dy);[p2, b2]=fileparts(p1);[p3, b3]=fileparts(p2);[p4, b4]=fileparts(p3); [p5, b5]=fileparts(p4);
    bn=[b5 '_' b4 '_' b1];            
    [x,ns,fs]=ReFbkSigDir(dy,Mic);
    fd=[NRootD '/' bn '.wav']; 
    if(exist(fd, 'file')>0); fprintf('WARNING: %s will be replaced\n',fd); pause; end  
    

    
    audiowrite(fd,x,fs);    
    fprintf('%d/%d:%s\n',i,la,fd);
    
end


