function CrEmbedNoisy1Dir(ORoot,IRoot,ISubDir,INoiseDir,P)
%Create Embeded Noisy at different Snrs
%
%IRoot:     Input Root. All the files in [IRoot '/' ISubDir] are mixed with noise 
%INoiseDir: Input NoiseDir. One of the noise files (~3 min) is randomly selected
%SnrV:      SNR Vector ([Inf 10 10 0 0]). Choose one of the values randomly for each file. If
%SnrV has one dimension e.g. [10] then the output dir name contains the SNR level.
%PrevMSnr:  Previus Mixture SNR (5). The clean signal (not noise) is gained to have a SNR level
%previus to the mixture. 
%NOTE:      The refence channel to do the SNR mixed is the one where noise (not clean
%speech) has maximun energy. It depends on the choosen noise file

%

PrevMSnr=P.PrevMSnr;
SnrV=P.SnrV;
SnrE=P.SnrE;

%
if (length(SnrV)==1)
  SnrSt=num2str(SnrV);       
else     
  SnrSt='Rand';    
end

NoisyEmbedDir   =[ORoot '/' ISubDir '_' SnrSt 'dB'];  
ClEmbedDir      =[ORoot '/' ISubDir '_' SnrSt 'dBClean'];



ICleanDir=[IRoot '/' ISubDir];




CrEmbedNoisy(NoisyEmbedDir,ClEmbedDir,ICleanDir,INoiseDir,PrevMSnr,SnrV,SnrE); %4


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CrEmbedNoisy(NoisyEmbedDir,ClEmbedDir,ICleanDir,INoiseDir,PrevMSnr,SnrV,SnrE)
%
%Input: ICleanDir, INoiseDir and Parameters
%Output: INoiseDir,NoisyEmbedDir

FLsec=0.032;
FSsec=0.010;

fx=dir([ICleanDir '/*.wav']); 
fn=dir([INoiseDir '/*.wav']); 

flx=size(fx,1); 
fln=size(fn,1);
[s,m,n] = rmdir(NoisyEmbedDir,'s'); mkdir(NoisyEmbedDir); 
[s,m,n] = rmdir(ClEmbedDir,'s'); mkdir(ClEmbedDir); 


for i=1:flx 
    [oxm, FSamp]=audioread([ICleanDir '/' fx(i).name]); FL=FLsec*FSamp; FS=FSsec*FSamp; 
    
    
    a=[INoiseDir '/' fn(ceil(rand(1)*fln)).name]; fprintf('Reading %s ..',a);     [onm, FSamp]=audioread(a); onm=repmat(onm,[2 1]); fprintf('read.\n'); 
       
    
    [Snr,RefCh]=SnrRefChSel(SnrV,oxm,onm);    
    [NInt,xfa,nfa]=FindNInt(oxm(:,RefCh),onm(:,RefCh),FL,FS,PrevMSnr,Snr,SnrE); 
            
    
    nm=nfa*onm(NInt,:); xm=xfa*oxm;
    clear onm; clear oxm;
    [ym,xm,nm]=FinalYXN(xm,nm,0.99);   nmref=nm(:,RefCh); clear nm;
    
    
    [pn bn] = fileparts(fx(i).name);     
    fnoisy=[NoisyEmbedDir '/' fx(i).name];
    fclean=[ClEmbedDir '/' fx(i).name];
    finfo=[ICleanDir '/' bn '.txt'];     

    fprintf('Writting: %s\n',fnoisy); audiowrite(fnoisy,ym,FSamp);  clear ym;
    fprintf('Writting: %s\n',fclean); audiowrite(fclean,xm,FSamp);  xmref=xm(:,RefCh); clear xm; 
    
    if(exist(finfo,'file')~=0)
        copyfile(finfo,NoisyEmbedDir); 
        copyfile(finfo,ClEmbedDir);
    else
        fprintf('WARNING in CrEmbedNoisy: does not exist %s\n',finfo);
    end        
    fprintf('Written noisy %s (with a SNR of %f), clean %s and Info.txt\n',fnoisy,ObSnrSig(xmref,nmref,FL,FS),fclean);
        
      
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [Snr,RefCh]=SnrRefChSel(SnrV,xm,nm)
%SNR and Reference Channel Selection
%The SNR is random selected.  The RefCh is the maximun energy channel of
%noise
Snr=SnrV(randi(length(SnrV),1));
%Ex=sqrt(mean(xm.^2));
En=sqrt(mean(nm.^2));
[v p]=max(En);
RefCh=p;



function [y,x,n]=FinalYXN(xo,no,mayx)
%xo and no are matrix
x=xo; n=no;
y=x+n; ma=max(max(y(:)),max(x(:)));
if (ma>1.0)
    f=mayx/ma; x=x*f; n=n*f; y=x+n;
    fprintf('WARNING: x and n multiplied by %f to avoid clipped\n',f);    
end




function [NInt,xf,nf]=FindNInt(x,n,FL,FS,PrevMSnr,Snr,SnrE)
%Find X and N. x and n are monoaural (usually channel 6); 
%(X is modified if not found any good Snr)

%X correction to noise level
xf1=XG4Snr(x,n,PrevMSnr,FL,FS); x=xf1*x;  
%Find SNRs intervals
IEn=IEner(n,FL,FS); IEx=IEner(x,FL,FS); 
[ISnr,lc]=SnrCand(IEx,IEn,Snr,SnrE);

%Default out
NInt=1:length(x); xf=xf1; nf=0;

%Estimated out
if(~isinf(Snr))
    xf2=1;    
    if (sum(lc)==0)
        %subplot(211), plot(ISnr), hold on, plot(ones(1,length(ISnr))*Snr,'r'), hold off
        d=Snr-ISnr; [v,p]=min(abs(d)); SnrD=d(p); xf2=10^(SnrD/(10*2)); x=xf2*x; 
        IEx=IEner(x,FL,FS); [ISnr,lc]=SnrCand(IEx,IEn,Snr,SnrE);
        %subplot(212), plot(ISnr), hold on, plot(ones(1,length(ISnr))*Snr,'r'), hold off
        fprintf('WARNING: x signal multiplied by %f for good SNR\n',xf2);
    end			
    j=1:length(lc); 
    fc=j(lc); %frame candidates
    sc=fc(ceil(rand(1)*length(fc))); %selected candidate
    ss=(sc-1)*FS+1; %start sample	
    
    xf=xf1*xf2; NInt=ss:ss+length(x)-1; nf=1;
end





function G=XG4Snr(x,n,TSNR,FL,FS)
%X-Gain For a specific Snr (x=G*x)
IEn=IEner(n,FL,FS); IEx=IEner(x,FL,FS); 
EnM=mean(IEn);     ExM=mean(IEx);
G=sqrt((EnM/ExM)*10^(TSNR/10));
 


function [ISnr,lc]=SnrCand(IEx,IEn,Snr,SnrE)
%Snr Frame Candidates
vx=-1; %vx=ObVad(IEx);
lx=length(IEx); ln2=length(IEn)-lx;
ISnr=zeros(1,ln2);
for j=1:ln2
		ISnr(j)=ObSnrIE(IEx,IEn(j:j+lx-1),vx);		
end
lc=(ISnr<(Snr+SnrE))&(ISnr>(Snr-SnrE)); %logic candidate

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Snr=ObSnrSig(xo,no,FL,FS)
%
IEx=IEner(xo,FL,FS); IEn=IEner(no,FL,FS);  vx=-1; %vx=ObVad(IEx);
Snr=ObSnrIE(IEx,IEn,vx);

function Snr=ObSnrIE(IEx,IEn,vx)
%
%En=sum(IEn(vx));   %the final noise will be higher, this can produce high noise in silences
En=sum(IEn);        %the final noise will be smaller, this avoids high noise in silences
%Ex=sum(IEx(vx));    %the final noise will be a bit smaller, (Ex is smaller and En have to be smaller too)
Ex=sum(IEx);	     %the final noise will be a bit higher, (Ex is higher and En have to be higher too) 
Snr=10*log10(Ex/En);

function v=ObVad(IE)
%
EL=sqrt(var(IE));
v=IE>EL; %plot(IE), hold on, plot(EL*ones(1,length(IE))), hold off, pause


function [IE]=IEner(x,FL,FS)
%Segmentation FL (Frame Length), FS (Frame Shift)
lx=length(x);
nf=ceil((lx-FL)/FS);
M=zeros(FL,nf);
j=0;
for i=1:FS:lx-FL
    j=j+1;
    M(:,j)=x(i:i+FL-1);    
end
IE=sum(M.^2);



