function GrazConv3
%
%SNR of GrazConversations

addpath('./AnnaSNR')
addpath('../CommonFun')

%Input
% Sp={'038F039F' '003M023F'  '026F027F'  '031F011M'  '033F034F' ...
% '001M002M'  '006M007M'  '009M010M'  '015M017M'  '021F022F' ...
% '029F030F'  '004M024F'  '013M014M'  '025F005M'  '032F012M' ...
% '037F019M'  '016M018M'  '028F008M'  '035F036F'};

Sp={'001aM' '002aM' '003aM' '004aM' '005aM' '006aM' ...
    '007aM' '008aM' '009aM' '010aM' '011aF' '012aF' ...
    '013aF' '014aF' '015aF' '016aF' '017aF' '018aF'...
    '019aF' '020aF' '021aF'};


%IRoot='/afs/spsc.tugraz.at/resources/databases_new/all/INCOMING/GrazCorpus';
IRoot='/clusterFS/project/DIRHA/20130819_DIRHA_VAD';


P.Ext='.wav';
P.FSamp=16000;
P.SLSec=60; %Segment Length in Seconds
P.SL=P.FSamp*P.SLSec; %Segment Length


%
ORoot='/clusterFS/home/user/jamc/SPEECHDATA/GRAZCONV_All/Old/SNRNoConv2';


% for i=1:length(Sp)
%     DI=[IRoot '/' Sp{i}];
%     DO=[ORoot '/' Sp{i}];
%     SplResampDir(DO,DI,P)
% end

for i=1:length(Sp)
    DI=[ORoot '/' Sp{i}];
    [snr,min]=DirSNR(DI,P);
    snrs=sprintf('%.2f ', snr);
    fprintf('SNR for %s (%d min): %s\n\n',Sp{i},min,snrs);
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [snro, min]=DirSNR(DI,P)
%
fy=dir([DI  '/*' P.Ext]); 
lfy=length(fy);
fprintf('%d: ',lfy);
for i=1:lfy  
    fprintf('%d ',i);
    
    fn=[DI '/' fy(i).name]; 
    [y, FSamp] = wavread(fn);    
    %y=0.2*randn(960000,5); FSamp=16000;
       
    
    [ns(i),nch]=size(y);
    for j=1:nch
        ymono=y(:,j);    ymono=ymono(4000:end-4000);    
        setup.Fsnew=FSamp;   setup.cur_dir = 'HE02M';
        snr(j,i) = af_SNRiirSmoothing_(ymono,setup.cur_dir,setup,0,'xx',setup.cur_dir);
              
       %snr(j,i)=30;
    end     
end
sns=sum(ns); min=sns/(60*FSamp);
nsm=repmat(ns,[nch,1]); 
snro=sum(nsm.*snr,2)/sns;
fprintf('\n');



function SplResampDir(DO,DI,P)
%Split and Resample a Dir
[x,x,x]=rmdir(DO,'s'); mkdir(DO);
fy=dir([DI  '/*' P.Ext]); 
for i=1:length(fy)           
    fn=[DI '/' fy(i).name]; 
    [pn, bn]=fileparts(fn);    
    %y48=0.99*rand(4327050,5); FSampI=48000; %y48=min(y48,0.99);
    %[y48, FSampI] = wavread(fn);
    [y48, FSampI] = WavReadTUGrazStudio(fn);     
    
    
    [N,D]=rat(P.FSamp/FSampI);
    y=resample(y48,N,D); 
    [ns,nch]=size(y);
    nseg=ceil(ns/P.SL);
    for j=1:nseg
      fno=[DO '/' bn '_' num2str(j) P.Ext];
      mi=(j-1)*P.SL+1;   ma=min((j)*P.SL,ns);
      yint=y(mi:ma,:);
      wavwrite(yint,P.FSamp,fno);
      fprintf('Written: %s\n',fno);
    end    

end    




