function GrazConv2
%Create NoConversation part
%Isolate Te/Tr Separation of all the speakers (at 48kHz)
%Create Embed Tr/Te Embed (at 16kHz)
%
%The kind of utt are choosen in Te.UK and Te.UN as follows:
% Tr1
% 5046 = 1843 (97ut/sp * 19sp) + 3203 (89ut/sp * 36Sp);
% T1
% 380 = 20ut/sp * 19sp;
% T2
% 380 = 20ut/sp * 19sp;
% 
%         Tr1 T1   
% 15 =    8  7     Reading RC
% 15 =    8  7     Spontaneous SC
% 10 =    6  4     KeyW RK
% 5  =    3  2     SpontKW SK
% 72 =    72 0    ReadBas BE KO ST ..
% -------------------------------------
% 117 ut = 97  20   

addpath('../CommonFun')
addpath('./Fun')
ParalDir='/clusterFS/home/user/jamc/Results/LogMatParalDir'; [x,x,x]=rmdir(ParalDir,'s'); mkdir(ParalDir);

%Input
Te.Sp={'001M' '002M'}; %speakers
% Te.Sp={'001M' '002M'  '009M' '010M'  '021F' '022F'  '029F' '030F'  '035F' '036F' ...
% '003M' '023F'  '013M' '014M'  '025F' '005M'  '031F' '011M'  '037F' '019M' ...
% '004M' '024F'  '015M' '017M'  '026F' '027F'  '032F' '012M'  '038F' '039F' ...
% '006M' '007M'  '016M' '018M'  '028F' '008M'  '033F' '034F'}; %speakers






Te.UK={'_RC_', '_SC_', '_RK_', '_SK_', '-1'}; %utterances kind (at the end is -1)
Te.UN={ 7,     10,      5,      3,      25}; %utterances numbers for the kinds 50 in total)
IRoot='/clusterFS/home/user/jamc/SpeechData/DIRHA/GRASS_48kHzSingleSpeakers';


%Input for Embed
P.Pos={'-1'};
P.Ext='.wav';
P.MiGSec=0.5; P.MaGSec=5; %Gaps In Seconds
P.MaIsolN=-1; %Max Isolated Numbers
P.IsolN=[10]; %Isolated Numbers
P.xsFSamp=16000;
P.InSubFolderSp=0; %In SubFolderSp
P.AsrRoot='/clusterFS/home/user/jamc/AsrEngine';



%Output
ORoot='/clusterFS/home/user/jamc/SpeechData/GRAZCONV_All/Aux';
TeRootIsol48=[ORoot '/Test1CleanIsol48'];
TrRootIsol48=[ORoot '/Train1CleanIsol48'];

TeRootEmbed=[ORoot '/Test1/NoConv'];
TrRootEmbed=[ORoot '/Train1Clean/NoConv'];

%
%Isolate Te/Tr Separation of all the speakers (at 48kHz)
for i=1:length(Te.Sp)
    TrTeSep1Dir(TeRootIsol48,TrRootIsol48,IRoot,Te.Sp{i},Te.UK,Te.UN,P.Ext)
end



%Create Embed Tr/Te Embed
CrEmbedClean(TrRootEmbed,TrRootIsol48,Te.Sp,P,ParalDir);
CrEmbedClean(TeRootEmbed,TeRootIsol48,Te.Sp,P,ParalDir);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CrEmbedClean(RO,RI,Sp,P,ParalDir)
%
[x,x,x]=rmdir(RO,'s'); mkdir(RO); 
for i=1:length(Sp)     
    P.RO=RO;    P.RI=RI;    P.Sp=Sp{i};    
    MatP=[ParalDir '/P' num2str(i) '.mat'];   save(MatP,'P');
    CrEmbedClean1Dir(MatP);
end 





