function GrazConv1
%Create Conversation Part
%1) ReSample (48000 to 16000) 1min Barbara files
%2) Separate mix speakers files. From Barbara 2 Juan Informamation (Barbara
%info in seconds so dont worry about that my files are at 16000)
%3) Separate the speakers Conv: TestFN for Test and the remiender for Train

addpath('../CommonFun')
addpath('./Fun')

%Input
% YDir={'013M014M_CUT_singlechannel' '028F008M_CUT_singlechannel' '029F030F_CUT_singlechannel' ...
%     '033F034F_CUT_singlechannel' '037F019M_CUT_singlechannel'};
%SpN={'013M' '014M' '028F' '008M' '029F' '030F' '033F' '034F' '037F' '019M'};

% YDir={'001M002M_CUT_singlechannel'  '009M010M_CUT_singlechannel'  '021F022F_CUT_singlechannel'  '029F030F_CUT_singlechannel' ...  
% '035F036F_CUT_singlechannel'  '003M023F_CUT_singlechannel'  '013M014M_CUT_singlechannel'  '025F005M_CUT_singlechannel' ...  
% '031F011M_CUT_singlechannel'  '037F019M_CUT_singlechannel'  '004M024F_CUT_singlechannel'  '015M017M_CUT_singlechannel' ...  
% '026F027F_CUT_singlechannel'  '032F012M_CUT_singlechannel'  '038F039F_CUT_singlechannel'  '006M007M_CUT_singlechannel' ...  
% '016M018M_CUT_singlechannel'  '028F008M_CUT_singlechannel'  '033F034F_CUT_singlechannel'};
% 
% Sp={'001M' '002M'  '009M' '010M'  '021F' '022F'  '029F' '030F'  '035F' '036F' ...
% '003M' '023F'  '013M' '014M'  '025F' '005M'  '031F' '011M'  '037F' '019M' ...
% '004M' '024F'  '015M' '017M'  '026F' '027F'  '032F' '012M'  '038F' '039F' ...
% '006M' '007M'  '016M' '018M'  '028F' '008M'  '033F' '034F'};

%Speakers to convert
YDir={'001M002M_CUT_singlechannel'};
Sp={'001M' '002M'};


%Barbara format path
IRoot='/afs/spsc.tugraz.at/project/GrazCorpus/3_d/Conversations_CUT_16kHz';

P.Ext='.wav';
P.TestFN=20; %Test File number (the reminder for Train)
ofs=16000;

%Output
ORoot='/clusterFS/home/user/jamc/SpeechData/GRAZCONV_All/Aux';
TeORoot=[ORoot '/Test1'];
TrORoot=[ORoot '/Train1Clean'];

%
ResampleTest1(ORoot,IRoot,YDir,ofs);
ReStructTest1(ORoot,ORoot,YDir,Sp,P.Ext)
SepTeTr(TeORoot,TrORoot,ORoot,Sp,P.TestFN,P.Ext);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function SepTeTr(TeORoot,TrORoot,IRoot,Sp,TestFN,Ext)
%Separate in Test and Tr
for i=1:length(Sp)
  DI=[IRoot '/' Sp{i}];  
  DO=[TeORoot '/Conv' Sp{i}]; [x,x,x]=rmdir(DO,'s'); mkdir(DO);  
  fy=dir([DI '/*' Ext]);    

  l=size(fy,1); 
  
  TestFN2=TestFN;
  if l<TestFN;  %sometimes TestFN(=20)<l then change     
      TestFN2=round(l*2/3);  
      fprintf('WARNING: Changed TestFN to %d\n',TestFN);      
  end 
  
  
  k=randperm(l); 
  

  fprintf('Creating %s\n',DO);
  
  %Test
  for j=1:TestFN2
       fprintf(' %d',j);
 
     [pn, bn]=fileparts(fy(k(j)).name);
     IWav=[DI '/' bn '.wav'];
     IInf=[DI '/' bn '.txt'];
     OWav=[DO '/' bn '.wav'];
     OInf=[DO '/' bn '.txt'];     
     copyfile(IWav,OWav);  copyfile(IInf,OInf);      
  end  
  %Training
  DO=[TrORoot '/Conv' Sp{i}]; [x,x,x]=rmdir(DO,'s'); mkdir(DO); 
  for j=TestFN2+1:l
     [pn, bn]=fileparts(fy(k(j)).name);
     IWav=[DI '/' bn '.wav'];
     IInf=[DI '/' bn '.txt'];
     OWav=[DO '/' bn '.wav'];
     OInf=[DO '/' bn '.txt'];   
     copyfile(IWav,OWav);  copyfile(IInf,OInf);
  end  
end



function ResampleTest1(ORoot,IRoot,YDir,ofs)
%
for i=1:length(YDir)    
    DI=[IRoot '/' YDir{i}];
    DO=[ORoot '/' YDir{i}]  
    ReSampDir(DI,DO,ofs,'.wav');   
    s=['cp ' DI '/*txt ' DO]; system(s);      
end


function ReStructTest1(ORoot,IRoot,SpDir,SpN,Ext)
%ReStructurate and 
for i=1:length(SpN)
    mkdir([ORoot '/' SpN{i}])    
end
%
for i=1:length(SpDir)    
    IDir=[IRoot '/' SpDir{i}];    
    fy=dir([IDir '/*' Ext]);  
    l=size(fy,1);   
    for j=1:l
        
        [pn, bn]=fileparts(fy(j).name);
        %
        wavfi=[IDir '/' bn Ext];
        infofi=[IDir '/' bn '.txt'];
        
        S=ReGrazConvInfo(IDir,bn);        
        %
        wavfo=[ORoot '/' bn(10:13) '/' bn '.wav'];
        inffo=[ORoot '/' bn(10:13) '/' bn '.txt'];
        %
        copyfile(wavfi,wavfo);
        fprintf('%d/%d:%s\n',j,l,wavfo);
        
        WriteInfo(S,inffo);                
    end   
end


