function S=ReGrazConvInfo(dy,bno)
%Read Barbara-Info file which segmentation is in seconds. Read FSamp of corresponding wav
%file. Write the Juan-Info file which information is in samples


infof=[dy '/' bno '.txt'];
wavf=[dy '/' bno '.wav']; [x,FSamp]=ReSWav(wavf); lx=length(x); 



if(exist(infof,'file')==2)
    fi=fopen(infof,'r');
    C = textscan(fi,'%s %s\n');
    fclose(fi);
    B=C{2};
    l=length(B);
    if(l>0)
        j=1;
        for i=1:l    
            [pn bn]=fileparts(B{i});  bns=regexp(bn, '_', 'split'); sten=regexp(bns{end}, '-', 'split');
            [st,en,DD] =GrazConvSe2Sa(sten{1},sten{2},FSamp,lx,bn); 
            if (DD>2*512)
                 S.pos{j}='-1'; S.bn{j}=bn; S.st{j}=st; S.en{j}=en; j=j+1;
            else
                fprintf('WARNING in ReGrazConvInfo: %s is ignored because is too short\n',bn);
            end
            
        end
    else
        fprintf('WARNING in ReGrazConvInfo: %s is empty and ignored\n',bno);        
        S.st{1}='1'; S.en{1}='-1'; S.pos{1}='-1'; S.bn{1}='-1';
    end
    
else
    fprintf('WARNING in ReGrazConvInfo: invented .txt for %s\n',bno);  
    S.st{1}='1'; S.en{1}=num2str(lx); S.pos{1}='-1'; S.bn{1}=bno;
end



function [StSa, EnSa, DD]=GrazConvSe2Sa(StSe,EnSe,FSamp,lx,bn)
%Second To Samples 
StSa=Se2Sa(StSe,FSamp,lx,bn);
EnSa=Se2Sa(EnSe,FSamp,lx,bn);
DD=str2double(EnSa)-str2double(StSa);

function Sa=Se2Sa(Se,FSamp,lx,bn)
%
a=FSamp*(str2double(Se)/10000000);
if(a<0), fprintf('WARNING in ReGrazConvInfo: %s ini time changed\n',bn);  end
if(a>lx), fprintf('WARNING in ReGrazConvInfo: %s end time changed\n',bn);  end
a=max(1,a); a=min(lx,a);

Sa=num2str(round(a)); 

function [xo,fs]=ReSWav(fn)
%Read Stereo Wave file, fn: file name
[xs,fs,nb]=wavread(fn); 
if (size(xs,2)==2); xo=[xs (xs(:,1)+xs(:,2))/2];
else xo=xs; end


