%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   First-Order IIR Smoothing [1] 
%   28.05.2013
%   @ Anna Fuchs
%   
%  
%   v1.0                                                        28.05.2013  
%   v2.0    Adapt algorithm to Database                         13.06.2013
%   v3.0    New speaker are added to database                   31.07.2013
%   v4.0    Change structure a little bit                       01.08.2013
%   v5.0    l. 76 changed to setup.Fsnew*2                      22.08.2013
%   v6.0    l. 36 length dependent on signal length not on Fs   30.08.2013
%           -- macht anscheinend keinen Unterschied.
%   [1]Acoustic Echo and Noise Control A practical Approach; Eberhard
%   Haensler, Gerhard Schmidt; S.319; 13.4.4.4 First-Order IIR Smoothing
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [snr] = af_SNRiirSmoothing_(sig,speaker,setup,DEBUG,sen,name)

T_sm = 0.2;
gamma = (T_sm*setup.Fsnew-1)/(T_sm*setup.Fsnew+1);
gamma_r = gamma;
gamma_f = gamma*0.989;


% initial values
res(1) = 0.0000001;
b(1) = 0.0000001;
epsilon = 0.00002; 
thres2 = -200;  % for EL speech

[res,b] = af_iirSmooth(sig,gamma_r,gamma_f,thres2,epsilon,res,b);

% Segmental SNR with geometrical averaging
% snr = 10 * log10(res(:) ./ b(:));     % This is equal to the subtraction of the mean snr values
% snr(snr < 2) = [];                    % snr values for noise are neglected (critical threshold!!!)
% snr(isnan(snr)) = [];
% snr = mean(snr);

% Segmental SNNR with arithmetical averaging
snr = ((res(:)-b(:)) ./ b(:));     % This is equal to the subtraction of the mean snr values
% snr1 = snr;
tmptmp = (snr./(max(snr)));
% snr1(snr < 40) = []; 
% snr1 = 10*log10(mean(snr))
snr(tmptmp < 0.001) = [];                    % snr values for noise are neglected (critical threshold!!!)
snr(isnan(snr)) = [];
snr = 10*log10(mean(snr));

if 0
    figure
    plot(((res(:)-b(:)) ./ b(:))./(max(((res(:)-b(:)) ./ b(:)))))
    hold on
    plot(ones(length(res),1) * 0.001,'--m')
end

if DEBUG      
    
        figure(1)
        plot(10*log10(res))
        hold on
        plot(10*log10(b),'r')
        plot(ones(length(res),1) * 10*log10(mean(res)),'--b')  
        plot(ones(length(b),1) * 10*log10(mean(b)),'--r')
        plot(ones(length(res),1) * 10*log10(b(1)),'--g') 
        plot(ones(length(res),1) * (10*log10(min(res))+2),'--k')     
        legend('Energy','Noise','Energy Level','Noise Level','Init-Value','Thrs for SNR')
        title(sprintf('%s; snr = %d dB', sen,round(snr)))
        
        figure(2)
        plot(sig)
end

function [res,b] = af_iirSmooth(sig,gamma_r,gamma_f,thres2,epsilon,res,b)
% IIR smoothing and SL & NL estimation
for nk = 2:size(sig,1)
    if sig(nk)^2 > res(nk-1)
        gamma_ = gamma_r;
    else 
        gamma_ = gamma_f;        
    end
    res(nk) = (1-gamma_)*sig(nk).^2+gamma_*res(nk-1);
    % Wenn Sprecher EL ein und aus schaltet waehrend dem Sprechen   
    if 10*log10(res(nk)) < thres2             
        res(nk) = res(nk-1);
    end
    b(nk) = min(res(nk),b(nk-1))*(1+epsilon);
end