function [KA6,LA6,R1C,C1R,B2C]=FbkMicArrPar(P,dy)
%FBK Microphone Arrays Parameters
%Everything start from Fbk Info Sources and Channel position information file

%SrcFn='/clusterFS/home/user/jamc/SPEECHDATA/DIRHAGRID_All/Info/Sources_position.txt';
%ChFn='/clusterFS/home/user/jamc/SPEECHDATA/DIRHAGRID_All/Info/channel_lst.txt';


[dn,bn]=fileparts(dy);
[dn,bn]=fileparts(dn);
SrcFn=[dn '/Info/Sources_position.txt'];
ChFn=[dn '/Info/channel_lst.txt'];





%
[Src.PosN,Src.XYZ]=ReSrcPos(SrcFn);
[Ch.PosN,Ch.XYZ]=ReChPos(ChFn);


%About Src
KA6XYZ=PosN2XYZ({'KA6'},Ch.PosN,Ch.XYZ); KA6=RefMicInfo(Src,'K',KA6XYZ);
LA6XYZ=PosN2XYZ({'LA6'},Ch.PosN,Ch.XYZ); LA6=RefMicInfo(Src,'L',LA6XYZ);
R1CXYZ=PosN2XYZ({'R1C'},Ch.PosN,Ch.XYZ); R1C=RefMicInfo(Src,'R',R1CXYZ);
C1RXYZ=PosN2XYZ({'C1R'},Ch.PosN,Ch.XYZ); C1R=RefMicInfo(Src,'C',C1RXYZ);
B2CXYZ=PosN2XYZ({'B2C'},Ch.PosN,Ch.XYZ); B2C=RefMicInfo(Src,'B',B2CXYZ);


%About Ch LA6 and KA6 Radios in meters (from the average)
%MicDM = 0.2; %Mic Distant in Meter
MicAVD = [90 18 306 234 162]; %Mic Angles Vector in Degrees (respect signal matrix)

XYZ=PosN2XYZ({'KA1' 'KA2' 'KA3' 'KA4' 'KA5'},Ch.PosN,Ch.XYZ);
KA6.MicRMe=mean(sqrt(sum((XYZ-repmat(KA6XYZ,[1 5])).^2)));
%KA6.MicRMe=0.20;
KA6.MicADeg=MicAVD; %Compute in the future depending on positions

XYZ=PosN2XYZ({'LA1' 'LA2' 'LA3' 'LA4' 'LA5'},Ch.PosN,Ch.XYZ);
LA6.MicRMe=mean(sqrt(sum((XYZ-repmat(LA6XYZ,[1 5])).^2)));
%LA6.MicRMe=0.20;
LA6.MicADeg=MicAVD; %Compute in the future depending on positions

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function RefMic=RefMicInfo(Src,Room,RefMicXYZ)
%Coordinates regarding RefXYZ
[PosNI,XYZI]=RoomSel(Src.PosN,Src.XYZ,Room);
[RefMic]=FBK2TUGrazCoordChang(XYZI,PosNI,RefMicXYZ);


function XYZ=PosN2XYZ(PosN,APosN,AXYZ)
%
%PosN: is a cell {'LA1' 'LA2' 'LA3' 'LA4' 'LA5' 'LA6'}
l=length(PosN);
for i=1:l
    t=strcmp(PosN{i},APosN); a=AXYZ(:,t);
    XYZ(:,i)=a;
end   
    

function [S]=FBK2TUGrazCoordChang(XYZI,PosNI,XYZRef)
%
l=size(XYZI,2);
for i=1:l    
    a=XYZI(:,i)-XYZRef;  a(2)=-a(2);     
    [ar,er,r] = cart2sph(a(1),a(2),a(3));
    b=[mod(360*ar/(2*pi),360); mod(360*er/(2*pi),360); r];  
    
    XYZ(:,i)=a;
    SPH(:,i)=b;    
end
PosN=PosNI;
S.PosN=PosN; S.XYZ=XYZ; S.SPH=SPH;


% function Pp=O2Op(P)
% %
% Op=[190.9 245.9 274.3];
% Pp=(P-Op)/100;
% Pp(2)=-Pp(2);



function [PosNO,XYZO]=RoomSel(PosN,XYZ,Room)
%
l=length(PosN);
t=false(1,l);
for i=1:l
    if Room==PosN{i}(1)
        t(i)=1;
    end   
end
PosNO=PosN(t);
XYZO=XYZ(:,t);


function [PosN,XYZMe]=ReSrcPos(SrcFn)
%XYZ in Meters
fi=fopen(SrcFn,'r');
if fi==-1; fprintf('ERROR in FbkMicArrPar: %s doesnt exist\n',SrcFn); end

l=fgetl(fi); j=1;


while ischar(l)
    C=regexpi(l, ' +', 'split');
    W=regexpi(C{2}, '/', 'split'); PosN{j}=[W{3} W{4}];
    
    
    if strcmp(PosN{j},'SXBEDROOM'); PosN{j}='BOO1'; end
    if strcmp(PosN{j},'DXBEDROOM'); PosN{j}='BPO1'; end     
    if strcmp(PosN{j},'DXKITCHEN'); PosN{j}='KSO5'; end 
    if strcmp(PosN{j},'SXKITCHEN'); PosN{j}='KTO5'; end     
    if strcmp(PosN{j},'DXLIVINGROOM'); PosN{j}='LSO1'; end 
    if strcmp(PosN{j},'SXLIVINGROOM'); PosN{j}='LTO1'; end 
    %fprintf('%s\n',PosN{j}); 
    
    
    
    W=regexpi(C{5}, '=', 'split'); x(j)=str2num(W{2});
    W=regexpi(C{6}, '=', 'split'); y(j)=str2num(W{2});
    W=regexpi(C{7}, '=', 'split'); z(j)=str2num(W{2});    
    l=fgetl(fi); j=j+1;
end
fclose(fi);
XYZMe=[x; y; z]/100;



function [PosN,XYZMe]=ReChPos(ChFn)
%XYZMe
fi=fopen(ChFn,'r');
l=fgetl(fi); j=1;
while ischar(l)
    C=regexpi(l, ' +', 'split');   
    PosN{j}=C{1};
    W=regexpi(C{4}, '=', 'split'); x(j)=str2num(W{2});
    W=regexpi(C{5}, '=', 'split'); y(j)=str2num(W{2});
    W=regexpi(C{6}, '=', 'split'); z(j)=str2num(W{2});    
    l=fgetl(fi); j=j+1;
end
fclose(fi);
XYZMe=[x; y; z]/100;


