function CrEmbedClean1Dir(RO,RI,Sp,P)
%
%Create Embeded Clean
%It needs that you previously create the RI/Sp.{i} folder with all the isolated sentences to embed. 
%Take all the isolated sentences in RI/Sp.{i} and create embedded in RO/Sp{i} with the following configuration.
%
%RI: folder with isolated imputs RI/Sp.{i}
%RO: folder with embed outputs RO/Sp.{i}
%
%P.IsolNEmb=8; %Isolated Numbers per Embbed (on average). The distribution is 
                %automatically done using all the sentences of the RI/Sp.{i} folder
                %with around P.IsolNEmb per embedded (see function EqPartion) 
%P.Pos={'LFO8'  'LGO6'  'LMO4'  'LLO2'};    %if P.Pos={'-1'} then only change the sampling freq and embed monaural
%P.Pos={'CA' 'CB' 'CC'};                    %if direction Pos(3:4) not given, choose randomly
%P.Ext='.wav';
%P.MiGSec=0.5; P.MaGSec=5; %Gaps In Seconds
%P.xsFSamp=16000; %stereo-array output sample freq
%P.InSubFolderSp=1; %1: output distributed in subfolders: [RO '/' Sp{i}];
%0: all outputs in RO (for this case  Clean and create previusly RO)
%P.Mic={'KA6' 'LA6' 'R1C' 'C1R' 'B2C'}; %Microphones of output signal. 


%
DI=[RI '/' Sp];
fy=dir([DI '/*' P.Ext]); 
AS=RanOrdPosIsol(DI,fy,P); 

S=DivAS(AS,P);


%
DO=[RO '/' Sp]; [x,x,x]=rmdir(DO,'s'); mkdir(DO); 
for j=1:length(S)
    WrEmbedS(S(j),P,[DO '/' Sp num2str(j)]);       
end    

 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=DivAS(AS,P)
%Divide All Structure

 
    P.MaIsolN=length(AS.bn);
    P.IsolNEmb=EqPartion(P.MaIsolN,P.IsolNEmb);
    fprintf('From the %d chosen this partition: ',P.MaIsolN)
    P.IsolNEmb    



k=0;
for i=1:length(P.IsolNEmb)    
    for j=1:P.IsolNEmb(i)
        u=k+j;
        S(i).x{j}=AS.x{u};
        S(i).bn{j}=AS.bn{u};
        S(i).pos{j}=AS.pos{u};
        S(i).FSamp=AS.FSamp;
    end
    k=k+P.IsolNEmb(i);    
end




function WrEmbedS(S,P,fn)
%Write Embed from S
[x,S]=EmbedClean(S,P.MaGSec,P.MiGSec);  
audiowrite([fn '.wav'],x,S.FSamp);       
WriteInfo(S,[fn '.txt']);
fprintf('Written %s.wav\n',fn);

function [x,S]=EmbedClean(S,MaGSec,MiGSec)
%Random embedetion of isolate sentences
ChN=size(S.x{1},2);
IsolN=length(S.x); 
D=MiGSec+(MaGSec-MiGSec)*rand(1,IsolN+1); D=round(D*S.FSamp);
x=[]; S.st=cell(IsolN,1); S.en=cell(IsolN,1);
for i=1:IsolN 
    x=[x; zeros(D(i),ChN);];
    S.st{i}=num2str(length(x)+1); x=[x; S.x{i};]; S.en{i}=num2str(length(x));       
end
x=[x; zeros(D(IsolN+1),ChN);];


function [S]=RanOrdPosIsol(ClIsolDir,fy,P)
%Random Order and Position of Isolate

P.MaIsolN=length(fy);

PosN=length(P.Pos);
a=ceil(rand(P.MaIsolN,1)*PosN); %Random Positions of Isolates
S.x=cell(P.MaIsolN,1); S.bn=cell(P.MaIsolN,1); S.pos=cell(P.MaIsolN,1);
p=randperm(P.MaIsolN); %Randon Order of Isolates


for i=1:P.MaIsolN
    S.pos{i}=P.Pos{a(i)}; 
    S.bn{i}=fy(p(i)).name;    
    fni=[ClIsolDir '/'  S.bn{i}];   
    fprintf('Read fni:%s\n',fni);
    
     [x, xFSamp]=audioread(fni);   
    
    %x=0.5*randn(250,1); xFSamp=8000;    
    
%     if(strcmp(S.pos{i},'-1'))      
%       [N,D]=rat(P.xsFSamp/xFSamp); 
%       fprintf('No position-reverberation: only resampling %d/%d\n',N,D);
%       xs=resample(x,N,D); 
%     else          
%       %[xs]=Mono2FBKMicArr(x,xFSamp,S.pos{i},P.xsFSamp,P.Mic,0,P.FbkIRRoot);     
%       %[xs]=Mono2SimHouse(x,xFSamp,S.pos{i},P.xsFSamp,P.Mic,0); %we do not use really FbkIRRoot because they have not yet realeased
%             
%     end

    xs=x;
    
    S.x{i}=xs; S.FSamp=P.xsFSamp;    

end



%%%%%%%%%%%%%%%%%%% EqPartion %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function IsolN=EqPartion(MaIsolN,OIsolN)
%Equally Partition
% MaIsolN=29;
% OIsolN=6;
% IsolN=[8     7     7     7];

IsolN=DistrN(MaIsolN,OIsolN);
EmbN=length(IsolN)-1;

ex1=floor(IsolN(end)/EmbN);
ex2=IsolN(end)-(ex1*EmbN);
for i=1:EmbN
    IsolN(i)=IsolN(i)+ex1;
end
IsolN(1)=IsolN(1)+ex2;
IsolN(end)=[];


function IsolN=DistrN(MaIsolN,OIsolN)
EmbN=floor(MaIsolN/OIsolN); 
r=rem(MaIsolN,OIsolN);

%
IsolN=zeros(1,EmbN+1);
for i=1:EmbN
    IsolN(i)=OIsolN;
end
IsolN(EmbN+1)=r;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


