function [n,xsimu]=GetDevNoise(o,r,x,fs)
%
%Input: 
%o: original from bth /home/jmorales/SpeechData/CHIME3_All/CHiME3/data/audio/16kHz/isolated/dt05_bth/M04_050C0101_BTH.CH0.wav
%r: close mic of emb /home/jmorales/SpeechData/CHIME3_All/CHiME3/data/audio/16kHz/embedded/M04_141107_040_BUS.CH0.wav
%x: other mics of emb/home/jmorales/SpeechData/CHIME3_All/CHiME3/data/audio/16kHz/embedded/M04_141107_040_BUS.CH.wav
%fs: Sample Freq in Hz
%Output
%n: noise
%xsimu: noisy (should be very similar to original development)


%
wlen_sub=256; % STFT window length in samples
blen_sub=4000; % average block length in samples for speech subtraction (250 ms)
ntap_sub=12; % filter length in frames for speech subtraction (88 ms)
wlen_add=1024; % STFT window length in samples for speaker localization
del=-3; % minimum delay (0 for a causal filter)
nchan=6;
nsampl=length(r);

%Compute back noise: n
disp('Compute the STFT (short window)')
R=stft_multi(r.',wlen_sub);
X=stft_multi(x.',wlen_sub);

disp('Estimate 88 ms impulse responses on 250 ms time blocks')
A=estimate_ir(R,X,blen_sub,ntap_sub,del);

disp('Filter and subtract close-mic speech')
Y=apply_ir(A,R,del);
y=istft_multi(Y,nsampl).';
level=sum(sum(y.^2));
n=x-y; %x: noisy, y: clean, n: noise but not scaled

% Now use o
disp('Compute the STFT (long window)')
O=stft_multi(o.',wlen_add);
X=stft_multi(x.',wlen_add);
[nbin,nfram] = size(O);

disp('Localize and track the speaker')
[~,TDOAx]=localize(X);

disp('Interpolate the spatial position over the duration of clean speech')
TDOA=zeros(nchan,nfram);
for c=1:nchan,
    TDOA(c,:)=interp1(0:size(X,2)-1,TDOAx(c,:),(0:nfram-1)/(nfram-1)*(size(X,2)-1));
end

disp('Filter clean speech')
Ysimu=zeros(nbin,nfram,nchan);
for f=1:nbin,
    for t=1:nfram,
        Df=sqrt(1/nchan)*exp(-2*1i*pi*(f-1)/wlen_add*fs*TDOA(:,t));
        Ysimu(f,t,:)=permute(Df*O(f,t),[2 3 1]);
    end
end
ysimu=istft_multi(Ysimu,nsampl).';

disp('Normalize level and add')
ysimu=sqrt(level/sum(sum(ysimu.^2)))*ysimu;
xsimu=ysimu+n; %x: noisy, y: clean, n: noise
        
%
z=zeros(nsampl,1);
xsimu=[z xsimu];
n=[z n];

% %Normalize to 1 in case of bigger than 1
% ma1=max(abs(n(:)));
% ma2=max(abs(xsimu(:)));
% ma=max(ma1,ma2);
% if ma>1; n=n./ma; xsimu=xsimu/ma; end


% subplot(311), plot(xsimu)
% subplot(312), plot(ysimu)
% subplot(313), plot(n)
% pause
