function AS=ReAllJSon(ajson,k,AnDir,P,TmpDir)
%
%Read all json with any information on embbed 
ASMat=[TmpDir '/ASMat.mat'];
if ~exist(ASMat,'file')    
    AS=[];
    for i=1:length(ajson)  
        i
        
        f=[AnDir '/' ajson{i}];
        
        [pn, bn]=fileparts(f); InfoMat=[TmpDir '/' bn '.mat'];
        JSonS=LoSaMatJSon(f,InfoMat);
        [S]=FindBackEmbBthJSonS(JSonS,P,k{i},ajson{i});         
        AS=[AS S];    
    end
    save(ASMat,'AS');     
end
a=load(ASMat); AS=a.AS;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [S]=FindBackEmbBthJSonS(ainfo,P,k,ajson)
%IN FUTURE: SUBTITUTE BY WHAT IS IN SHARE FUN Folder

l=length(ainfo);

for i=1:l
    f=ainfo{i};        
    
    [pn, bn]=fileparts(ajson);
    
    bnf=[bn '/' f.speaker '_' f.wsj_name '_' f.environment];  %Basename: bth (dev) or wjs0 (tr) file            
    
    
    
        switch k
            
            case 'w' %wav
                nfbn=f.wavfile;  C=strsplit(nfbn,'_'); ndir=lower(C{end});
                embf=[P.EmbRoot '/' ndir '/' f.wavfile '.wav'];
                s=f.start;
                e=f.end;               
                
                
            case 'b' %background
                nfbn=f.noise_wavfile;  C=strsplit(nfbn,'_'); ndir=lower(C{end});
                embf=[P.BackRoot '/' ndir '/' nfbn '.wav'];  
                s=f.noise_start;
                e=f.noise_end;
                
            case 'e' %embedded                
                nfbn=f.noise_wavfile;  C=strsplit(nfbn,'_'); ndir=lower(C{end});
                embf=[P.EmbRoot '/' ndir '/' nfbn '.wav'];
                s=f.noise_start;
                e=f.noise_end;    
                
                %To observe that bth and embf from different speaker!!!!!!!!!!!!!!!!!!   
                %[bnf,embf] pause
                
                
                
        end
        
        %devbthf=[P.DevBthDir '/' f.speaker '_' f.wsj_name '_BTH' '.wav'];               
        
    
    S(i).embf=embf;
    S(i).s=s;
    S(i).e=e;
    S(i).bnf=bnf;
    S(i).dot=f.dot;
    
    
end

