function CrEmbedNoisy1Dir_AddNoiseGap(ORoot,IRoot,ISubDir,INoiseDir,SpeechNoiseRoot,P)
%Create Embeded Noisy of 1 Dir, Add Noise Gap
%
%IRoot:     Input Root. All the files in [IRoot '/' ISubDir] are mixed with noise 
%INoiseDir: Input NoiseDir. One of the noise files (~3 min) is randomly selected
%SnrV:      SNR Vector ([Inf 10 10 0 0]). Choose one of the values randomly for each file. If
%SnrV has one dimension e.g. [10] then the output dir name contains the SNR level.
%PrevMSnr:  Previus Mixture SNR (5). The clean signal (not noise) is gained to have a SNR level
%previus to the mixture. 
%NOTE:      The refence channel to do the SNR mixed is the one where noise (not clean
%speech) has maximun energy. It depends on the choosen noise file

%



NoisyEmbedDir   =[ORoot '/' ISubDir];  
ClEmbedDir      =[ORoot '/' ISubDir '_clean'];
SpeechNoiseDir  =[SpeechNoiseRoot '/' ISubDir '_noise'];


ICleanDir=[IRoot '/' ISubDir];

CrEmbedNoisy(NoisyEmbedDir,ClEmbedDir,ICleanDir,INoiseDir,SpeechNoiseDir); %4


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CrEmbedNoisy(NoisyEmbedDir,ClEmbedDir,ICleanDir,INoiseDir,SpeechNoiseDir)
%
%Input: ICleanDir, INoiseDir and Parameters
%Output: INoiseDir,NoisyEmbedDir

FLsec=0.032;
FSsec=0.010;

fx=dir([ICleanDir '/*.wav']); 
fn=dir([INoiseDir '/*.wav']); 

flx=size(fx,1); 
fln=size(fn,1);
[s,m,n] = rmdir(NoisyEmbedDir,'s'); mkdir(NoisyEmbedDir); 
[s,m,n] = rmdir(ClEmbedDir,'s'); mkdir(ClEmbedDir); 


for i=1:flx 
    
    %Read Clean    
    [pn,bn]=fileparts(fx(i).name);    
    [xm, FSamp]=audioread([ICleanDir '/' bn '.wav']); 
    [xl,nch]=size(xm);
    S=ReInfo(ICleanDir,bn,xl);  
    nu=length(S);
         
    %Chose randon embbed file noise and randon segment    
    fin=[INoiseDir '/' fn(randi(fln)).name];   %File   
    
    InfoS=audioinfo(fin); nl=InfoS.TotalSamples; iini=round((nl-xl)*rand(1)); iend=iini+xl;   
    [nm, FSamp]=audioread(fin,[iini+1, iend]);   
    fprintf('Readed [%d %d] samples of %s\n',iini, iend,fin);    
    
%     %Final noise (replaced by speech noise) 
%     for j=1:nu        
%         fisn=[SpeechNoiseDir '/' S(j).bn '.wav'];
%         [spn,Fs]=audioread(fisn);        
%         a=str2double(S(j).st);
%         b=str2double(S(j).en);          
%         nm(a:b,:)=spn;    
%     end
        
    %Mix      
    ym=xm+nm;   
        
    %Write        
     [pn bn] = fileparts(fx(i).name);     
     fnoisy=[NoisyEmbedDir '/' fx(i).name];
     fclean=[ClEmbedDir '/' fx(i).name];
     finfo=[ICleanDir '/' bn '.txt'];    
     
     if(exist(finfo,'file')~=0)
         copyfile(finfo,NoisyEmbedDir); 
         copyfile(finfo,ClEmbedDir);
     else
         fprintf('WARNING in CrEmbedNoisy: does not exist %s\n',finfo);
     end    
    
     
     yma=max(abs(ym(:)));
  
     
     if yma > 1; ym=ym/yma; xm=xm/yma; end    
     
       
     
    fprintf('Writting: %s\n',fnoisy); audiowrite(fnoisy,ym,FSamp); 
    fprintf('Writting: %s\n',fclean); audiowrite(fclean,xm,FSamp);  
    
    
    
    
%     subplot(311), plot(xm)
%     subplot(312), plot(nm)
%     subplot(313), plot(ym)
%     pause
        
      
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
