function Chime3_3
%Split Dev (and Tr) in smaller folders

CommonRoot='/home/jmorales/AsrEngine/MatlabFE/JuanFE/Common/';
addpath([CommonRoot '/Matlab']); %just for StArFNExtract.m



%IRoot
%IRoot='/home/jmorales/SpeechData/CHIME3_All/Tr';
%Fo={'tr05_bus_simu'  'tr05_caf_simu'  'tr05_ped_simu'  'tr05_str_simu'};
IRoot='/home/jmorales/SpeechData/CHIME3_All/DevTe';

%Fo={'dt05_bus_simu' 'dt05_caf_simu'  'dt05_ped_simu'  'dt05_str_simu'};
Fo={'et05_bus_simu' 'et05_caf_simu'  'et05_ped_simu'  'et05_str_simu'};


%
NFDir=5;

%
ORoot=[IRoot '/Aux']; [x,x,x]=mkdir(ORoot);


for i=1:length(Fo)
    
    %Noisy
    BN=Fo{i};
    IDirY=[IRoot '/' BN];   
    ODirY=[ORoot '/' BN];    
    SplitDir(ODirY,IDirY,NFDir,'.wav');        

end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function SplitDir(OODir,IDir,NFDir,Ext)
%Split Directory
%NFDir: Number of File per Directory

fy=dir([IDir '/*' Ext]); 
C=StArFNExtract(fy,'name');
name=sort(C);
l=length(name); 


fprintf('Doing of %d (%s):\n',l,IDir);

for i=1:l
    
    %fi and fo noisy and noise
    fiy=[IDir '/' name{i}];
    fin=[IDir '_noise/' name{i}];    
    a=num2str(ceil(i/NFDir));
    ODir=[OODir '_' a];    
    foy=[ODir '/' name{i}];   
    fon=[ODir '_noise/' name{i}];    
    
    %Noisy: Create output folder if doesnt exist and copy file
    CrDirFNoExit(foy);
    copyfile(fiy,foy);
    
    %Noise: same as noisy if exist noise    
    if exist(fin,'file')
        CrDirFNoExit(fon);    
        copyfile(fin,fon); 
    end
    
    %
    fprintf('%d ',i);   
    if mod(i,30)==0; fprintf('\n'); end
    
    
    
end

fprintf('Written dir: %s\n',OODir);


function CrDirFNoExit(foy)
%Creat Dir of File if Not Exist
[pn, bn]=fileparts(foy);
    if ~exist(pn,'dir')
        system(['mkdir -p ' pn]);    
    end
