function Chime3_2
%Create background noises for Tr and Dev Simu (for Real not possible)
%Tr:    Clean: from WSJ0 (011_011C0204_STR, 409_409C021C_BUS...). Noise: from Backgrounds Noises 
%Dev:   Clean: from BTH (F01_050C0103_BUS, M04_423C020X_BUS...). Noise: from Complicate
%       Embbed: chose one similar isolated of 1 embed (from same or different speaker!!!!!!),
%       substract Backgroud Noise (using close talk microphone) and
%       Impulse Response, then convolve and sum. 
%

addpath('./utils'); 
addpath('./ShareASRFun'); 
addpath('./ShareASRFun/simulation'); 

%Input
Chi3Root='/home/jmorales/SpeechData/CHIME3_All';
AnDir=[Chi3Root '/CHiME3/data/annotations']; %Annotation Dir


%Input that depend on dt, tr or et 
k='dt';
Fo={[k '05_bus_simu'] [k '05_caf_simu']  [k '05_ped_simu']  [k '05_str_simu']}; 
f=[AnDir '/' k '05_simu.json'];
switch k
    case 'dt'
        EmbK='e'; %More information about when EmbK 'b' or 'e' or 'w' in Chim3Vad_2.m
        IDir='OrigDevTeSimu_NotDelete'; 
        
    case 'et' 
        EmbK='e'; 
        IDir='OrigDevTeSimu_NotDelete';  
    case 'tr'
        EmbK='b'; 
        IDir='Tr';
end
IRoot=[Chi3Root '/' IDir];


%Derive Input
P.BackRoot=[Chi3Root '/Back'];
P.EmbRoot =[Chi3Root '/Emb'];
P.BthDir=[IRoot '/' k '05_bth'];
P.Ext='.wav';


%ORoot
TmpDir='./Tmp';
ORootN=[IRoot '/AuxNoise']; 
ORootY=[IRoot '/AuxNoisy'];

%
[pn, bn]=fileparts(f); InfoMat=[TmpDir '/' bn '.mat'];
info=LoSaMatJSon(f,InfoMat);

%
l=length(Fo);
for i=1:l
    %To paralize (qsub)       
    IDir=[IRoot '/' Fo{i}];
    ODirN=[ORootN '/' Fo{i}];
    ODirY=[ORootY '/' Fo{i}];  
    FindBack(info,ODirN,ODirY,IDir,EmbK,P);   % b (for 1) e (for 2) 
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function FindBack(JSonS,ODirN,ODirY,IDir,EmbK,P)
%
fy=dir([IDir '/*' P.Ext]); 
l=size(fy,1); 
[x,x,x]=mkdir(ODirN); [x,x,x]=mkdir(ODirY);
for i=1:l    
    fprintf('%d/%d \n',i,l);    
    %ComparOrigNewNoisy([IDir '/' fy(i).name]);    
    [pn, bn]=fileparts(fy(i).name);         
    [S]=FindBackEmbBth1F(JSonS,bn,EmbK,P.EmbRoot,P.BackRoot,P.BthDir);    
    WriteNoise([ODirN '/' bn P.Ext],[ODirY '/' bn P.Ext],[IDir '/' bn P.Ext],S,EmbK);      
end
fprintf('Written: %s.\n',ODirN);



function WriteNoise(noisef,simunoisyf,noisyf,S,k)
%s,e: start and end in seconds
%S: backf,embf,devbthf,s,e

[y,Fs]=audioread(noisyf);
switch k
    case 'b' %from backf
        [n,Fs]=ReLoFCoLe(S.backf,S.s,S.e,y);
        audiowrite(noisef,n,Fs);
        
    case 'e' %from embedded        
        [e,Fs]=ReLoFCoLe(S.embf,S.s,S.e,y);           
        [bth,Fs]=audioread(S.bthf);        
        [n,ysimu]=GetDevNoise(bth(:,1),e(:,1),e(:,2:end),Fs);          
%       %observe that embed and bth can be from different     %speakers!!!!!!!!!!!!!!!        
        audiowrite(noisef,n,Fs);
        audiowrite(simunoisyf,ysimu,Fs);
end
fprintf('Written: %s.\n',noisef);




function [n,Fs]=ReLoFCoLe(backf,s,e,y)
%Read Long File and Compare with Lenght
%

%New Fast
info = audioinfo(backf); Fs=info.SampleRate;
ss=round(s*Fs); es=round(e*Fs);
[n,Fs]=audioread(backf,[ss+1,es+0]); %step very slow if not selected interval in advance
if length(y)~=length(n)    
        fprintf('WARNING in: n and y different length for %s\n',backf);
end



function ComparOrigNewNoisy(fn)
%Compare (after 1 normalization the gain) of Original and New Noisy

[p1, b1]=fileparts(fn); [p2, b2]=fileparts(p1); [p3, b3]=fileparts(p2);
OrigRoot='/home/jmorales/SpeechData/CHIME3_All/OrigDevTeSimu_NotDelete';
NewRoot=['/home/jmorales/SpeechData/CHIME3_All/' b3];
fo=strrep(fn, NewRoot, OrigRoot);
[o,Fs]=audioread(fo);  
[n,Fs]=audioread(fn);  
%
d=o-n; e=mean((d(:)).^2);
fprintf('Error: %d\n',e)
if e>4e-9
    subplot(211), plot(o)
    subplot(212), plot(n)
    pause
end








