function Chime3Vad_3
%First execute  Chime3Vad_1 to obtain clean isolated signals
%
%Create noisy embedded signals using clean no reverberated isolated signals (it needs FBK impulses
%responses and noises) 
%The final output is in NoisyEmbedRoot: the noisy embedded files (at  and the
%SNRs of P.SnrV) and the corresponding clean (noisy-clean=noise)

%Add paths
addpath('../CommonFun')
addpath('../CommonFun/Fbk2TUGraz');
addpath('../CommonFun/MicArray')
addpath('./Fun')


%Inputs paths
DevTr   ='Dev';
NoiseK  = {'bus' 'caf' 'ped' 'str'}; %Noise Kind
IsoRoot ='/home/jmorales/SpeechData/CHIME3_All/NoisyEmb/Aux';   %Isolate Root (with speech no reververated clean utterances)

%
SpeechNoiseRoot=['/home/jmorales/SpeechData/CHIME3_All/' DevTr];



%Outputs paths
ORoot=['/home/jmorales/SpeechData/CHIME3_All/NoisyEmb/Aux2']; %Output Root (to write all results)
CleanEmbedRoot=[ORoot '/CleanEmbed']; %Clean reverberated Embedded Root 

NoisyEmbedRoot=[ORoot '/NoisyEmbed']; %Noisy Embedded Root
[x,x,x]=mkdir(ORoot); %Create ORoot

%Parameters for EmbedClean (reverberated)
P.Ext='.wav'; %audio file extension
P.xsFSamp=16000; %output sample frequency (FBK files are at 48kHz but we work at 16kHz)
P.MiGSec=0.5; P.MaGSec=4.5; %Gaps In Seconds
P.IsolNEmb=8; %Isolated Numbers per Embbed (on average see partion function)
P.Pos={'-1'};


l=length(NoiseK);
for i=1:l
    %
    IsoSubF         =['dt05_' NoiseK{i} '_simu']; %Isolate SubFolder (usually with utterances of one speaker)
    NoiseEmbedDir   =['/home/jmorales/SpeechData/CHIME3_All/Back/' NoiseK{i}]; %Noise Embedded Root

    %Clean reverberated embedded (use FBK impulses responses)
    CrEmbedClean1Dir(CleanEmbedRoot,IsoRoot,IsoSubF,P); 

    %Noisy embeded at SNR indicated by P.SnrV
    CrEmbedNoisy1Dir_AddNoiseGap(NoisyEmbedRoot,CleanEmbedRoot,IsoSubF,NoiseEmbedDir,SpeechNoiseRoot,P) 

end



    









