function HmmRCTAdaptFList(DirO, DirI, FList, P)
%Hmm Regresion Class Tree Adaptation from a File List


%
StatsF      = [DirI '/stats']; %TriPh State Ocupation Statistics
TrPhList	= [DirI '/TriPhList.txt']; %TriPh List
MlfTriPhTran = [DirI '/MlfTriPhTran.txt']; %TriPh Mlf Trans
HmmName     = 'HMMs.txt';
%
TrainDir    = [P.RecDir '/TrainGen/TrainDir'];
GlobalTr	= [TrainDir '/Common/HmmAdapt/global']; 
Config      = [TrainDir '/Common/Config.txt']; 
GlobConfig	= [TrainDir '/Common/HmmAdapt/config.global']; %Global Transformation
RCConfig	= [TrainDir '/Common/HmmAdapt/config.rc']; %Regresion Class Tree Transformation
%
TempRegTreeF    = [DirO '/TempRegTreeF.hed'];
XFormDir        = [DirO '/XFormDir'];
ClasDir         = [DirO '/ClasDir'];
TempFList       = [DirO '/TempFList.txt'];

%
if ~exist(XFormDir,'dir')||~exist(ClasDir,'dir')||~exist(DirO,'dir');  
    mkdir(XFormDir); mkdir(ClasDir); mkdir(DirO);  
end 


% Create in ClasDir: rtree.base, rtree.tree and global (independent of $TempAllFList so the same for all the speakers)
delete(TempRegTreeF);  
s1=['echo LS \"' StatsF '\"	> ' TempRegTreeF]; 
s2=['echo RC 32 \"rtree\"	>> ' TempRegTreeF];
s3=[P.HtkRoot '/HHEd -B -H ' DirI '/' HmmName ' -M ' ClasDir ' ' TempRegTreeF ' ' TrPhList]; 
s4=['cp ' GlobalTr ' ' ClasDir];
system([s1 ';' s2 ';' s3 ';' s4 ';']);  
    


%Read FList
AuxDirN='adapt';
FMask='*/%%%%%/*';

Move2SubDir(FList,TempFList,AuxDirN);

%Step1 (Global Transf.)  
s=[P.HtkRoot '/HERest -C ' Config ' -C ' GlobConfig ' -S ' TempFList ' -I ' MlfTriPhTran ...
' -u a -H ' DirI '/' HmmName ' -z s -K ' XFormDir ' mllr1 ' ...
' -J ' ClasDir ' -h ''' FMask  ''' ' TrPhList];
system(s);

%Step 2 (Regresion Class Tree Transf.) 
s=[P.HtkRoot '/HERest -C ' Config ' -C ' RCConfig ' -S ' TempFList ' -I ' MlfTriPhTran ...
' -u a -H ' DirI '/' HmmName ' -J ' XFormDir ' mllr1 -K ' XFormDir ' mllr2 ' ...
' -J ' ClasDir ' -h ''' FMask  ''' ' TrPhList];
system(s);

UnMove2SubDir(FList,TempFList);

%
delete(TempRegTreeF,TempFList)

fprintf('Adaptation in: %s\n',DirO);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Move2SubDir(FList,TempFList,AuxDirN)
%Move To Sub Directory
fi=fopen(FList,'r'); C=textscan(fi,'%s'); C=C{:}; fclose(fi);
l=length(C);
for i=1:l 
    [pn bn ex]=fileparts(C{i});    
    do=[pn '/' AuxDirN]; 
    if ~exist(do,'dir');  mkdir(do);   end 
    C2{i}=[do '/' bn ex];
    movefile(C{i},C2{i});   
end
fi=fopen(TempFList,'w'); fprintf(fi,'%s\n',C2{:}); fclose(fi);

function UnMove2SubDir(FList,TempFList)
%UnMove To SubDirectory
fi=fopen(FList,'r'); C=textscan(fi,'%s'); C=C{:}; fclose(fi);
fi=fopen(TempFList,'r'); C2=textscan(fi,'%s'); C2=C2{:}; fclose(fi);
l=length(C2);
for i=1:l    
    movefile(C2{i},C{i})
end

