function HmmAdapatTr(RootO,DirI,AllFList,TokF,ParF,kind) 
%General Hmm Adaptation Training
%RootO: 	Root Output (where output HMM or apaptation transformation are)
%DirI: 		Dir Input (where input HMM is)
%AllFList: 	List with All the Files
%TokF:		Token File (from each token we generate a new adapted model)
%ParF:		Parameter File (perhaps not neccesary)
%kind:          Kind of Adapatation '1' HmmReTrAdaptFList or '2' HmmRCTAdaptFList
 

% TokF: 'Dev1S' 'Dev1S1..Dev1S2'.  
% .AND. .OR. means separation between tokens
% 'Dev2S1.OR.Dev2S2' 'Dev2S.AND.Clean/s'  'Dev2S' 'Dev1S'
% kind:    adaptation kind ('0': No. '1': Retraining adapt. '2': Regresion class tree adapt)




% RootO='/clusterFS/home/user/jamc/SpeechData/Models/ASR/HMMFBKGEDIRHACep25CleanFEEmbBase0xxx/Adapt'; 
% DirI='/clusterFS/home/user/jamc/SpeechData/Models/ASR/HMMFBKGEDIRHACep25CleanFEEmbBase0xxx/SI'; 
% AllFList='/clusterFS/home/user/jamc/SpeechData/Models/ASR/HMMFBKGEDIRHACep25CleanFEEmbBase0xxx/TempTrList.txt'; 
% TokF='/clusterFS/home/user/jamc/SpeechData/Models/ASR/HMMFBKGEDIRHACep25CleanFEEmbBase0xxx/TempTrList.txt.Tok'; 
% ParF='/clusterFS/home/user/jamc/SpeechData/Models/ASR/HMMFBKGEDIRHACep25CleanFEEmbBase0xxx/TempTrList.txt.Par';
% kind='2';   



%
P=ReStr(ParF);
P.TempTokFList=[AllFList '.TempTok'];


%
fi=fopen(AllFList,'r');
C=textscan(fi,'%s'); C=C{:}; ABN=C;
fclose(fi);


%
[ATokC,ATok,ALoOp]=File2CellTok(TokF);

for i=1:length(ATokC)
    
    [BN,t]=SelBN(ABN,ATokC{i},ALoOp{i});       
    
    fi=fopen(P.TempTokFList,'w');   fprintf(fi,'%s\n',BN{:});   fclose(fi);   
    
    %system(['cat ' P.TempTokFList]);
    %ATokC{i}    
    %pause
    
    switch kind
        case '1'
            HmmReTrAdaptFList([RootO 'ReTr/' ATok{i}], DirI, P.TempTokFList,P); %retraining   
        case '2'
            HmmRCTAdaptFList([RootO 'RTC/' ATok{i}], DirI, P.TempTokFList,P);  %regresion class tree
    end
    
end

delete(P.TempTokFList);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [TokC,Tok,LoOp]=File2CellTok(SelTokF)
%
fi=fopen(SelTokF,'r');
C=textscan(fi,'%s'); C=C{:};
fclose(fi);
l=length(C);
for i=1:l
    W=regexpi(C{i}, '.AND.', 'split');  TokCAND{i}=W; 
    W=regexpi(C{i}, '.OR.', 'split');   TokCOR{i}=W; 
    
    if (length(TokCAND{i})>length(TokCOR{i})) %select which split more
        TokC{i}=TokCAND{i};
        LoOp{i}='.AND.';
    else
        TokC{i}=TokCOR{i};
        LoOp{i}='.OR.';
    end      
    Tok{i}=C{i};
end



function [BN,t]=SelBN(BNI,TokC,LoOp)
%
if ~isempty(TokC)
    l=length(BNI); TokN=length(TokC);
          
    if strcmp(LoOp,'.OR.'); ft=false(l,1); end
    if strcmp(LoOp,'.AND.'); ft=true(l,1); end 
        
    for j=1:TokN 
        t=false(l,1);
        for i=1:l; t(i)=~isempty(strfind(BNI{i},TokC{j})); end        
        if strcmp(LoOp,'.OR.'); ft=ft|t; end
        if strcmp(LoOp,'.AND.'); ft=ft&t; end            
    end        
    BN=BNI(ft);       
else    
    BN=BNI;  t=true(1,length(BN));
end

%Fake code to avoid errors in the next steps
if isempty(BN)
   BN=BNI(1);
   fprintf('WARNING in HmmAdapatTr: no adaptation files and selected %s\n',BN{:});
   fprintf('pause 5 sec\n');
   pause(5)
end
       
       




function P=ReStr(fn)
%
fi=fopen(fn,'r');
if (fi==-1)
  fprintf('WARNING in ReStr: %s doesnt exist\n',fn);
else
    l=fgetl(fi);
    i=1;
    while ischar(l)
      W=regexpi(l, ' = ', 'split');
      P.(W{1})=W{2};    
      l=fgetl(fi); i=i+1;  
    end
    fclose(fi);
end



