function AnalRes(NMixs,WER,RecDir,PrintDetail,MatEls)
% Analize result
% AnalRes('0','0','/clusterFS/home/user/jamc/AsrEngine/RECOGNIZER','1','4')
%NMixs: Number of Mixed folders in one 
%WER: Results in WER instead of WAcc
%RecDir: Recognition Results
%PrintDetail: Print also H,D,S,I,N for all the trials (useful for
%FEMatRes)
%MatEls: Matlab Element (column) to analize (0 not analize)

fp=fopen([RecDir '/Par.txt'],'r'); P=textscan(fp,'%s','delimiter','\n'); P=P{:}; fclose(fp); 
A=dlmread([RecDir '/Acc.txt']);   
H=dlmread([RecDir '/H.txt']); 
D=dlmread([RecDir '/D.txt']); 
S=dlmread([RecDir '/S.txt']); 
I=dlmread([RecDir '/I.txt']);
N=dlmread([RecDir '/N.txt']);
MatRes=dlmread([RecDir '/AllMatRes.txt']);
MatEl=str2double(MatEls);
NMix=str2double(NMixs);


if MatEl>0    
    [A,H,D,S,I,N]=PrintAnalMatRes(MatRes,P,NMix,MatEl,WER);     
end
    
if NMix>1     
      H=MixM(H,NMix);     
      D=MixM(D,NMix);
      S=MixM(S,NMix);
      I=MixM(I,NMix);
      N=MixM(N,NMix);
      A=100*(H-I)./N;
end




PrintAnalRes(str2num(WER),P,A,H,D,S,I,N,str2num(PrintDetail));



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [A,H,D,S,I,N]=PrintAnalMatRes(MatRes,P,NMix,MatEl,WER)
%
% i=0;
% FScore=ComprMat(MatRes,P,NMix,i+1,WER);
% Re=ComprMat(MatRes,P,NMix,i+2,WER);
% Pr=ComprMat(MatRes,P,NMix,i+3,WER);
% AED=ComprMat(MatRes,P,NMix,i+4,WER);
% 
% FScore0=ComprMat(MatRes,P,NMix,i+5,WER);
% Re0=ComprMat(MatRes,P,NMix,i+6,WER);
% Pr0=ComprMat(MatRes,P,NMix,i+7,WER);
% AED0=ComprMat(MatRes,P,NMix,i+8,WER);
% 
% 
% A=[Re Pr FScore Re0 Pr0 FScore0 AED];
% for i=1:size(A,1)
%     fprintf('%.3f  & ',A(i,:));
%     fprintf('\n')
% end
% pause
TrialN=length(P);
A=MatRes(:,MatEl); A=A';
x=length(A)/TrialN;
C=reshape(A,x,TrialN); C=C'; 
A=C; H=C; D=C; S=C; I=C; N=C;



function Am=MixM(A,NMix)
%Mix a Matrix
[nr nc]=size(A);
ncm=nc/NMix;
Am=zeros(nr,ncm);
for i=1:ncm
  Am(:,i)=sum(A(:,(i-1)*NMix+1:i*NMix),2);
end

function PrintAnalRes(WER,P,A,H,D,S,I,N,PrintDetail)
%Print Analized Results
if(WER==1) A=100-A; end

Am=mean(A,2); Hm=mean(H,2); Dm=mean(D,2); Sm=mean(S,2); Im=mean(I,2); Nm=mean(N,2);
NTri=length(P);  
fprintf('\nAll the trials are:\n')
for i=1:NTri
    Print1Trial(P,A,Am,H,Hm,D,Dm,S,Sm,I,Im,N,Nm,i,PrintDetail);    
end


[v p]=max(Am); if(WER==1) [v p]=min(Am); end

fprintf('\nThe best trial is:\n')
Print1Trial(P,A,Am,H,Hm,D,Dm,S,Sm,I,Im,N,Nm,p,PrintDetail);
fprintf('\n\n');

function Print1Trial(P,A,Am,H,Hm,D,Dm,S,Sm,I,Im,N,Nm,p,PrintDetail)
%
fprintf('%s  ', char(P(p)));fprintf('%2.2f ', A(p,:)); fprintf(' %2.2f\n',Am(p,:));
if PrintDetail
fprintf('H (');             fprintf('%2.0f ', H(p,:)); fprintf(' %2.0f) ',Hm(p,:));
fprintf('D (');             fprintf('%2.0f ', D(p,:)); fprintf(' %2.0f) ',Dm(p,:));
fprintf('S (');             fprintf('%2.0f ', S(p,:)); fprintf(' %2.0f) ',Sm(p,:));
fprintf('I (');             fprintf('%2.0f ', I(p,:)); fprintf(' %2.0f) ',Im(p,:));
fprintf('N (');             fprintf('%2.0f ', N(p,:)); fprintf(' %2.0f)\n',Nm(p,:));
end




