function a=FEDir(dy,dx,do,SMRoot,SoftRoot,SDBase,FEK,FEOpt1,FEOpt2,FEOpt3,FEOpt4)
%Feature Extraction of a noisy Directory 
%dy (noisy dir), dx (clean dir), do (output dir)
%SMRoot (Script Matlab Root), SoftRoot (Softwares Root)
%SDBase (Speech DataBase), FEK (FE Kind), FEOpt1-4 (FE Options)

%Parameters
P=DBParam(SMRoot,SoftRoot,SDBase);
P.FEOpt1=str2double(FEOpt1); P.FEOpt2=str2double(FEOpt2); 
P.FEOpt3=str2double(FEOpt3); P.FEOpt4=str2double(FEOpt4);
P.FEK=FEK;


%FE
%a=RunGmmTr(P); %Train Gmm for imputation
a=FED(dy, dx, do, P);


%Write employed FE Parameters for recognition 
WrStr(P,[do '/FEConfig.txt']);


      
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function am=FED(dy,dx,do,P)
%Feature Extractor of files of Dir dy
[x1,x2,x3]=rmdir(do,'s'); mkdir(do);
fy=dir([dy '/*' P.YExt]); l=size(fy,1); 
a=zeros(1,l);
dy,    
for i=1:l  
   [pn, bn]=fileparts(fy(i).name);
   [y,x,P]=ReNormYX(dy,dx,bn,P); 
     
   switch P.FEK    
    case 'FEBase';      a(i)=FEBase(y, x, do, bn, P); 
    case 'FEAWin';      a(i)=FEAWin(y, x, do, bn, P);
    case 'FESift';      a(i)=FESift(y, x, do, bn, P);  
    case 'FEVADTunN';   a(i)=FEVADTunN(y, x, do, bn, P); 
    case 'FEVADHarmM';  a(i)=FEVADHarmM(y, x, do, bn, P);         
    case 'FEDTWPit';    a(i)=FEDTWPit(y, x, do, bn, P);           
    case 'FEChime2';    a(i)=FEChime2(y, x, do, bn, P);   
    %case 'FENing';      a(i)=FEChime1NingF(y, x, do, bn, P);    
    case 'FEDirha';     a(i)=FEDirha(y, x, do, bn, P);        
    otherwise; fprintf('ERROR in FEDir: Unknow FE Kind\n');
   end    
   
end

am=0;
%am=mean(a)-sqrt(var(a));





