function DemoPlotRes(S,P)
%Plot Demo Results 


close all
FSize=15;
i=0;


FN=fieldnames(S);
l=length(FN); 


for j=1:l  
    

switch FN{j} 
    
    case 'y'
    i=i+1; figure(i), 
    plot(S.y), xlim([1 length(S.y)]), xlabel('time (sample)'), title('Input: Noisy signal','FontSize',FSize)


    case 'xest'
    i=i+1; figure(i), 
    plot(S.xest), xlim([1 length(S.xest)]), xlabel('time (sample)'), title('Output: clean signal estimate','FontSize',FSize)


    case 'py'
    i=i+1; figure(i), 
    plot(S.px), hold on, plot(S.py,'ro'), hold off, xlim([1 length(S.py)]),  
    xlabel('time (frame)'), title('Output: Clean (blue-line) and estimated (red-circle) pitch','FontSize',FSize)

    case 'Cxest'
    i=i+1; figure(i), 
    imagesc(S.Cxest), axis xy,      xlabel('time (frame)'), ylabel('cepstral channel'), title('Output: Cepstrogram clean estimate','FontSize',FSize)


    case 'Fbxest'
    i=i+1; figure(i), 
    imagesc(S.Fbxest), axis xy,        xlabel('time (frame)'), ylabel('spectral channel'), title('Output: Spectrogram clean estimate','FontSize',FSize)


    case 'Fbnest'
    i=i+1; figure(i), 
    imagesc(S.Fbnest), axis xy,        xlabel('time (frame)'), ylabel('spectral channel'), title('Output: Spectrogram noise estimate','FontSize',FSize)



    case 'Maskest'
    i=i+1; figure(i), 
    subplot(211), imagesc(S.Fby), axis xy,        xlabel('time (frame)'), ylabel('spectral channel'), title('Output: Noisy spectrogram','FontSize',FSize)
    subplot(212), imagesc(S.Maskest), axis xy,    xlabel('time (frame)'), ylabel('spectral channel'), title('Output: Missing data mask estimate','FontSize',FSize)
    

end
end


fprintf('Showing figures of %s.\nPress enter...\n', P.FEK)
pause
close all