function [SDBase, DBSize, FEK, FEOpt]=DemoFEPar(PaperN)
%Select FE Parameter of the a paper for the Demo
%PaperN: Paper Number ('0', '1',...)

DBSize  = '25'; %Database Size: 25 or All
FEOpt   = {'0', '0', '0', '0'}; %FE Options


switch PaperN       
    
    %Juan A. Morales-Cordovilla, Hannes Pessentheiner, Martin Hagmueller, Jose A. Gonzalez, Gernot Kubin 
    %"CVX-optimized Beamforming and Vector Taylor Series Compensation with German ASR employing Star-shaped Microphone Array"
    %Interspeech, 2013.
    case '8';  
        FEK     = 'FEDirha'; 
        SDBase  = 'EMBEDBAS';
        FEOpt   = {'2', '0', '0', '0'}; 
    
    % Juan A. Morales-Cordovilla, Hannes Pessentheiner, Martin Hagmueller,Pejman Mowlaee, Franz Pernkopf, Gernot Kubin 
    %A German distant speech recognizer based on 3D beamforming and harmonic missing data mask
    %AIA-DAGA. 2013
    case '7';  
        FEK     = 'FEDirha'; 
        SDBase  = 'EMBEDBAS';
        FEOpt   = {'3', '2', '0', '0'}; 
    
    % Pejman Mowlaee, Juan A. Morales-Cordovilla, Franz Pernkopf, Hannes Pessentheiner, Martin Hagmüller, Gernot Kubin 
    %"The 2nd 'CHIME' speech separation and recognition challenge: approaches on single-channel source separation and model-driven speech enhancement"
    %The 2nd CHiME Workshop. 2013
    case '6'; 
        FEK     = 'FEChime2'; 
        SDBase  = 'CHIME';        
                
    %Juan A. Morales-Cordovilla, Pablo Cabañas-Molero, Victoria Sánchez, Antonio M. Peinado and José A. González. 
    %"A robust pitch extractor based on DTW lines and CASA with application in noisy speech recognition". 
    % Iberspeech. November 2012    
    case '5';  
        FEK     = 'FEDTWPit'; 
        SDBase  = 'A2';     
        
        
    %Juan A. Morales-Cordovilla, Victoria Sánchez, Antonio M. Peinado and Ángel M. Gómez. 
    %"On the use of asymmetric windows for robust speech recognition". 
    % Circuits, Systems and Signal Processing (Springer), DOI:10.1007/s00034-011-9349-y. September, 2011. 
    case '4'; 
        FEK     = 'FEAWin'; 
        SDBase  = 'A2';          
   
   %Juan A. Morales-Cordovilla, Antonio M. Peinado and Victoria Sánchez. 
   %"Equivalences and Limits of Pitch-based Techniques for Robust Speech Recognition". 
   %RTTH (Spanish Speech Technology Network) International Course in Applications of Speech Technologies , Almuñecar, July, 2011.
   case '3'; 
        FEK     = 'FEVADHarmM';
        SDBase  = 'A2';          
        
        
   %Juan A. Morales-Cordovilla, Ning Ma, Victoria Sánchez, José L. Carmona, Antonio M. Peinado and Jon Barker. 
   %"A pitch based noise estimation technique for robust speech recognition with missing data". 
   %ICASSP . Prague, May, 2011.       
   case '2'; 
        FEK     = 'FEVADTunN'; 
        SDBase  = 'A2';             
        
    %Juan A. Morales-Cordovilla, Antonio M. Peinado, Victoria Sánchez and José A. Gonzalez. 
    %"Feature extraction based on pitch-synchronous averaging for robust speech recognition". 
    %IEEE Transactions on Audio, Speech and Language Processing , 19(3): 640-651. March, 2011. 
    case '1';         
        FEK     = 'FESift'; 
        SDBase  = 'A2'; 
        
    %Baseline (MFCC+CMN)    
    case '0'
        FEK     = 'FEBase'; 
        SDBase  = 'A2'; 
    
    %    
    otherwise
        fprintf('ERROR in DemoFEPar: paper unknown\n')
        
end   

   

