function [P]=DBParam(SMRoot,SoftRoot,SDBase)
%Database Parameters depending on Speech DataBase (SDBase)

switch SDBase 
     
case 'CHIME' 
    P = struct('FLSec', 0.032, 'FSSec', 0.010, 'NCH', 32, 'CepL', 13, 'YExt', '.wav', 'XExt', '.wav');   
    P.MF=-11.4498; %Minimum Floor in filterbank
    P.MinMS=exp(P.MF); %Minimum Magnitude spectrogram
    
case 'CHIMEWSJ'
    P=struct('FLSec', 0.032, 'FSSec', 0.010, 'NCH', 32, 'CepL', 13, 'YExt', '.wav', 'XExt', '.wav');   
    P.MF=-9.2821;
    P.MinMS=exp(P.MF);  
    
case 'BAS'
    P=struct('FLSec', 0.032, 'FSSec', 0.010,  'NCH', 26, 'CepL', 13, 'YExt', '.wav', 'XExt', '.wav');   
    P.MF=-7.6362;  %Reverb
    P.MinMS=exp(P.MF);   
    
case 'AIRBONE' 
    P=struct('FLSec', 0.032, 'FSSec', 0.010,  'NCH', 26, 'CepL', 13, 'YExt', '.wav', 'XExt', '.wav');   
    P.MF=-7.6362;  %Reverb
    P.MinMS=exp(P.MF);  
    
case 'DIRHA' 
    P=struct('FLSec', 0.032, 'FSSec', 0.010, 'NCH', 26, 'CepL', 13, 'YExt', '.wav', 'XExt', '.wav');   
    P.MF=-7.6362;  %Reverb
    P.MinMS=exp(P.MF);   
    
case 'EMBEDBAS' 
    P=struct('FLSec', 0.032, 'FSSec', 0.010,  'NCH', 26, 'CepL', 13, 'YExt', '.wav', 'XExt', '.wav');   
    P.MF=-7.6362;  %Reverb
    P.MinMS=exp(P.MF);  
    P.ImpNGaus='256'; P.ImpExt='.FbyNoD'; P.ImpGmmF=[SMRoot '/FEJuan/Common/Impute/GMM/Gmm' SDBase '.' P.ImpNGaus '.mat']; 
    load(P.ImpGmmF); P.mix=mix;   
    
case 'A2'   
    P = struct('FLSec', 0.032, 'FSSec', 0.010,  'NCH', 26, 'CepL', 13, 'YExt', '.08', 'XExt', '.08');    
    P.MF=-15; 
    P.MinMS=exp(P.MF);    
        
case 'A4'
    P = struct('FLSec', 0.032, 'FSSec', 0.010,  'NCH', 26, 'CepL', 13,  'YExt', '.wv1', 'XExt', '.wv1');    
    P.MF=-11.1603; P.MinMS=exp(P.MF);
    
otherwise
    fprintf('ERROR in DBParam: Unknown SpeechDataBase\n')
    
end

P.SMRoot=SMRoot; 
P.SoftRoot=SoftRoot;
P.SDBase=SDBase;





