function [SMRoot, SoftRoot, SpeechRoot, ResRoot, RecRoot]=AddSMPath(MainRoot)
%Add Script Matlab Paths


if nargin < 1
    MainRoot    = GetMainRootShF('../../../RECOGNIZER/ALLREC.sh'); 
end

%Get Paths from MainRoot
SMRoot      = [MainRoot '/AsrEngine/FEMatlab']; %Script Matlab Dir
ResRoot    = [MainRoot '/AsrEngine/RESULTS']; % Features Dir
RecRoot     = [MainRoot '/AsrEngine/RECOGNIZER']; 
SpeechRoot  = [MainRoot '/AsrEngine/SPEECHDATADemo']; %Speech database Dir
%SpeechRoot  = ['/clusterFS/home/user/jamc/SPEECHDATA']; %Speech database Dir
SoftRoot    = [SpeechRoot '/Softwares']; %Software Dir

%FE External 
addpath([SMRoot '/ExtFeat/'])
addpath([SMRoot '/ExtFeat/FranzFun'])
addpath([SMRoot '/ExtFeat/PejmFun'])
addpath([SMRoot '/ExtFeat/HannFun'])
addpath([SMRoot '/ExtFeat/FranzFun/Fun'])
addpath([SMRoot '/ExtFeat/PejmFun/Fun'])

addpath([SMRoot '/ExtFeat/HannFun/Fun'])
addpath([SMRoot '/ExtFeat/HannFun/bf/weightscvx'])
addpath([SMRoot '/ExtFeat/HannFun/bf/weightsds'])
addpath([SMRoot '/ExtFeat/HannFun/bf/files'])
addpath([SMRoot '/ExtFeat/HannFun/bf/lib'])
addpath([SMRoot '/ExtFeat/HannFun/bf/libnew'])
addpath([SMRoot '/ExtFeat/HannFun/bf/libold'])

          
%FE Juan 
addpath([SMRoot '/FEJuan/Recognizer'])
addpath([SMRoot '/FEJuan/Recognizer/Fun'])

addpath([SMRoot '/FEJuan/FEBase'])
addpath([SMRoot '/FEJuan/FEVADTunN'])
addpath([SMRoot '/FEJuan/FESift'])
addpath([SMRoot '/FEJuan/FEDirha'])

addpath([SMRoot '/FEJuan/FEOthers'])
addpath([SMRoot '/FEJuan/FENing'])
%addpath([SMRoot '/FEJuan/FENing/NeedFun'])
%addpath([SMRoot '/FEJuan/FENing/NeedFun/MexFun'])


%Common 
addpath([SMRoot '/FEJuan/Common/Impute'])
addpath([SMRoot '/FEJuan/Common/Impute/Fun'])
addpath([SMRoot '/FEJuan/Common/CASA'])
addpath([SMRoot '/FEJuan/Common'])
addpath([SMRoot '/FEJuan/Common/ReWr'])
addpath([SMRoot '/FEJuan/Common/Represent'])
addpath([SMRoot '/FEJuan/Common/Filter'])
addpath([SMRoot '/FEJuan/Common/Sounds'])

addpath([SMRoot '/FEJuan/Common/VAD'])
addpath([SMRoot '/FEJuan/Common/Pitch'])
addpath([SMRoot '/FEJuan/Common/Pitch/DTWPitch'])
addpath([SMRoot '/FEJuan/Common/Pitch/DTWPitch/Fun'])
addpath([SMRoot '/FEJuan/Common/Pitch/StandPitch'])


% Software
%addpath([SoftRoot '/PitchSoft/yin'])
%addpath([SoftRoot '/PitchSoft/voicebox'])
%addpath([SoftRoot '/playrec_scripts'])

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function MainRoot=GetMainRootShF(AllRecF)
%Get MainRoot from AllReconition from .sh File
fi=fopen(AllRecF,'r');
l = fgetl(fi);
MainRoot='';
while ischar(l)
    if(~ isempty(strfind(l, 'set MainRoot'))&&(l(1)~='#'))
        k=strfind(l, '='); l=l(k+1:end);   l=regexpi(l, '\s+', 'split'); i=strcmp(l,''); l=l(~i); l=l(1); 
        MainRoot=l{:};
    end
    l = fgetl(fi);    
end
fclose(fi);  
if(strcmp(MainRoot,''))
    MainRoot='/clusterFS/home/user/jamc';
    %MainRoot='/afs/spsc.tugraz.at/project/jamc/1_d';
    fprintf('WARNING: Automatical selection of MainRoot as %s',MainRoot);
end





