function Fbnest=VadPitN(My,Y,Fby,pit,vad,GSNR,P,N,Fbn)
%Vad Pitch Noise estimators

[nch nf]=size(Fby);
vad2=ones(1,nf); vad2(1:P.FLFr)=0; vad2(end-P.FLFr:end)=0; %vad2 (First Last Frame silence and rest unvoiced)

if (P.NoiseK==0)    %Vad2Noise
    vad=vad2;
    [VTN,VK]=VadNoise(Y,vad,P);
    
elseif (P.NoiseK==1)  %VadNoise
    [VTN,VK]=VadNoise(Y,vad,P);
	    
elseif (P.NoiseK==2)  %Vad2NoiseCeilTun
    vad=vad2;
    [VN,VK]=VadNoise(Y,vad,P);
    [TN,TK]=TunNoise(My,Y,pit,P);
    VTN=VadCeilTunN(VN,VK,TN,TK,pit,GSNR,P);
    
elseif (P.NoiseK==3)    %VadNoiseCeilTun   
    [VN,VK]=VadNoise(Y,vad,P);
    [TN,TK]=TunNoise(My,Y,pit,P);
    VTN=VadCeilTunN(VN,VK,TN,TK,pit,GSNR,P);
    
elseif (P.NoiseK==4)    %VadNoiseTun   
    [VN,VK]=VadNoise(Y,vad,P);
    [TN,TK]=TunNoise(My,Y,pit,P);
    VTN=VadTunN(VN,VK,TN,TK,pit,GSNR,P);
    
elseif (P.NoiseK==5)    %Oracle Noise   
    VTN=N;
	
end

if (P.NoiseK~=5) %Smoothing	
	VTN=SmoothTime(VTN,P.SmL);
end

Fbnest=SmoothFreqCompr(VTN,P.NCH,P.FSamp,P.N2pi,P.MF);
 




%  FbV=SmoothFreqCompr(VN,P.NCH,P.FSamp,P.N2pi,P.MF);
%  FbT=SmoothFreqCompr(TN,P.NCH,P.FSamp,P.N2pi,P.MF);
%  subplot(511), imagesc(Fbn), axis xy
%  subplot(512), imagesc(FbV), axis xy
%  subplot(513), imagesc(FbT), axis xy
%  subplot(514), imagesc(Fbnest), axis xy
%  subplot(515), plot(pit), xlim([1 length(vad)])
%  pause




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [VTN]=VadCeilTunN(VN,VK,TN,TK,py,GSNR,P)
%
VTN=VN; i=(VTN>TN)&TK; VTN(i)=TN(i);


function [VTN]=VadTunN(VN,VK,TN,TK,py,GSNR,P)
%
VTN=VN;
if (GSNR<P.GSNRTh); VTN(TK)=TN(TK);
else i=(VTN>TN)&TK; VTN(i)=TN(i); end


function [VN,VK]=VadNoise(Y,vad,P)
%
VK=false(size(Y)); VK(:,vad==0)=1;
VN=IntMKnownP(Y,VK,P.FLFr);


function [TN,TK]=TunNoise(My,Y,pit,P)
%
TN=TunN(Y,My,pit,P.win,P.N2pi); 
TK=false(size(Y));  TK(:,pit>0)=1;








