function VHMask=HarmVADMask(Fby,Ay,pit,vad,GSNR,P)
%Harmonocity VAD Mask (inspired in Jon Barker paper)

%Vad Mask
Y=exp(Fby);
VK=false(size(Y)); VK(:,vad==0)=1;
VN=IntMKnownP(Y,VK,P.FLFr); FbVN=log(VN);
VMask=YNSoftMask(exp(Fby),exp(FbVN),P.Thr,P.Sl,exp(P.MF)); 

%Harmonicity Mask
HMask=HarmMask(Ay,pit,P.HTh,P.HSl);

%Mix
VHMask=MixVadHarmMask(VMask, HMask, pit, GSNR, P.GSNRTh);


% %
% subplot(311), imagesc(VMask)
% subplot(312), imagesc(HMask)
% subplot(313), imagesc(VHMask)
% pause

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function HMask=HarmMask(Ay,pit,HTh,HSl)
%Return Known Noise in Harmonic Regions
%Pit (in samples, not in positions)
[nch,mk,nf]=size(Ay); 
Ay0=repmat(Ay(:,1,:),[1 mk]); Ayn=Ay./Ay0;
H=zeros(nch,nf);
i=pit>mk-1; pit(i)=pit(i)/2; pos=round(pit+1); 
for i=1:nf
    if pos(i)>2;     
        H(:,i)=Ayn(:,pos(i),i);        
        %H(:,i)=HarmSlice(Ayn(:,:,i),pos(i),0,mk);         
    end
end
u=pit==0;
HMask=1./(1+exp(-HSl*(H-HTh))); HMask(:,u)=0;


function H=HarmSlice(An,pos,h,nc)
%H column vector of Harmonicity
%h half wide of slice (pos-h:pos+h). 0 is equivalent to standard
ini=pos-h; fin=pos+h; 
if ini<1; ini=1; end
if fin>nc; fin=nc; end;
H=max(An(:,ini:fin), [], 2);


function VHMask=MixVadHarmMask(VMask, HMask, pit, GSNR, GSNRTh)
%
VHMask=VMask;
if GSNR<GSNRTh;  v=pit>1;  VHMask(:,v)=HMask(:,v); end


