function [a]=FEVADTunN(y, x, do, bn, P)
%Feature Extractor

%For Mel
P.FL=P.FSamp*P.FLSec; 
P.FS=P.FSamp*P.FSSec; 
P.N2pi=2^ceil(log2(P.FL*2));
P.win=hamming(P.FL); 

%For Pitch 
P.MaPitHz   = 270; %Max Pitch (Hz) (270 Hz)
P.MiPitHz   = 80; %Min Pitch (Hz) (80 Hz)
P.MiPitL  = round(P.FSamp/P.MaPitHz); %Min Pit Lag
P.MaPitL  = round(P.FSamp/P.MiPitHz);

%For VAD
P.NoiseK=4; %Noise Kind
P.Thr=-3; %mask Threshold
P.Sl=0.2; %mask Slope
P.GSNRTh=10; % Global SNR Threshold (dB)
P.HFSNRTh=3; % High Freq Thr (dB)
P.FLFr=10; %First Last Frames
P.SmL=2; %Smooth time Length
P.ui=20; %Unvoiced Interval
P.FricFact=2/3; %Fricative Factor [0 1]


%
S=SegmRepr(P,y,x);
S=PitVad(S,P,do,bn);
S=NoiseMask(S,P,do);
WriteOutFiles(S,P,do,bn);
a=-1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=SegmRepr(P,ys,xs)
%Segmentations and Representations
S.y=ys(:,end);  % S.y=OffPreEmph(S.y);
S.x=xs(:,end); S.n=S.y-S.x;
[S.My nf]=Segmx(S.y,P.FL,P.FS);
[S.Mx nf]=Segmx(S.x,P.FL,P.FS);
[S.Mn nf]=Segmx(S.n,P.FL,P.FS);
S.nf=nf;

S.Y=Msd(S.My,'x',P.N2pi,P);
S.X=Msd(S.Mx,'x',P.N2pi,P);
S.N=Msd(S.Mn,'x',P.N2pi,P);
S.Fby=SmoothFreqCompr(S.Y,P.NCH,P.FSamp,P.N2pi,P.MF);
S.Fbx=SmoothFreqCompr(S.X,P.NCH,P.FSamp,P.N2pi,P.MF);
S.Fbn=SmoothFreqCompr(S.N,P.NCH,P.FSamp,P.N2pi,P.MF);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=PitVad(S,P,do,bn)
%
%Pitch and vad
HTh=0.60; %0.70 Harmonicity Threshold
SnrTh=3; %3 dB, SNR Thr
HFL=4;  %4 half filter length for pitch mean
Int=6/5; %6/5 pitch interval of search around mean ([1,2])

apy=AcPitch(S.My,P,HTh,SnrTh,HFL,Int); apx=AcPitch(S.Mx,P,HTh,SnrTh,HFL,Int);
%dpx=DTWPitch(S.x,P); dpy=DTWPitch(S.y,P); 

S.py=apy; S.px=apx;
[S.vad,S.GSNR]=VADPitHF(S.Fby,S.py,P.FricFact,P.HFSNRTh,P.ui,P.FLFr,P.MinMS); S.GSNR


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=NoiseMask(S,P,do)
%Noise and Mask
[S.Fbnest]=VadPitN(S.My,S.Y,S.Fby,S.py,S.vad,S.GSNR,P,S.N,S.Fbn);
S.HMask=YNHardMask(exp(S.Fby),exp(S.Fbnest),P.Thr,exp(P.MF));    
S.SMask=YNSoftMask(exp(S.Fby),exp(S.Fbnest),P.Thr,P.Sl,exp(P.MF)); 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function WriteOutFiles(S,P,do,bn)
%Write Output

PS.y=S.y; 
PS.Fbnest=S.Fbnest;
PS.Fby=S.Fby; PS.Maskest=S.SMask; 
PS.py=S.py; PS.px=S.px; 
DemoPlotRes(PS,P)



S.Fby=AppDeltas(S.Fby,2,-1,'feat');
S.SMask=AppDeltas(S.SMask,2,-1,'mask');
WriteHTKF([do '/' bn '.Fby'], S.Fby, 1);
WriteHTKF([do '/' bn '.mask'], S.SMask, 1);
  
    
    
    
