function [a]=FEVADHarmM(y, x, do, bn, P)
%FE VAD+Harmonicity Mask (Inspired in Barker paper)

%For Mel
P.FL=P.FSamp*P.FLSec; 
P.FS=P.FSamp*P.FSSec; 
P.N2pi=2^ceil(log2(P.FL*2));
P.win=hamming(P.FL); 

%For Cochleagram
P.LCFHz=50; % Low Center Freq (50 Hz)
P.HCFHz=round(P.FSamp/2-(P.FSamp/(P.NCH))); %High Center Freq  (3750 or 7500  Hz)
P.FLms=P.FLSec*1000; %Frame Length (30 msec)
P.FSms=P.FSSec*1000; %Frame Shift (10 msec)
P.TIms=8; %Temporal integration (8 msec)
P.COMPR='log'; %Type of compression (default 'cuberoot')


%For Pitch and VAD
P.MaPitHz   = 270; %Max Pitch (Hz) (270 Hz)
P.MiPitHz   = 80; %Min Pitch (Hz) (80 Hz)
P.MiPitL  = round(P.FSamp/P.MaPitHz); %Min Pit Lag
P.MaPitL  = round(P.FSamp/P.MiPitHz);

P.NoiseK=4; %Noise Kind
P.Thr=-3; %mask Threshold (VAD Mask)
P.Sl=0.2; %mask Slope (VAD Mask)
P.HTh=0.75; %Harmonicity Thr 
P.HSl=200; %Harmoc. Slope


P.GSNRTh=10; % Global SNR Threshold
P.HFSNRTh=3; % High Freq Thr
P.FLFr=10; %First Last Frames
P.SmL=2; %Smooth time Length
P.ui=20; %Unvoiced Interval
P.FricFact=2/3; %Fricative Factor [0 1]


%
S=SegmRepr(P,y,x);
S=PitVad(S,P,do,bn);
S=NoiseMask(S,P,do);
WriteOutFiles(S,P,do,bn);
a=-1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=SegmRepr(P,ys,xs)
%Segmentations and Representations
S.y=ys(:,end);  % S.y=OffPreEmph(S.y);
S.x=xs(:,end); S.n=S.y-S.x;
[S.My nf]=Segmx(S.y,P.FL,P.FS);
[S.Mx nf]=Segmx(S.x,P.FL,P.FS);
S.Y=Msd(S.My,'x',P.N2pi,P);
S.X=Msd(S.Mx,'x',P.N2pi,P);
S.Fby=SmoothFreqCompr(S.Y,P.NCH,P.FSamp,P.N2pi,P.MF);
S.Fbx=SmoothFreqCompr(S.X,P.NCH,P.FSamp,P.N2pi,P.MF);



[S.FbyCochl, S.Ay] = ShefCochlCorrGram(S.y, P.FSamp, P.LCFHz, P.HCFHz, P.NCH, P.FLms, P.FSms, P.TIms, P.COMPR, P.MF, P.FL, P.FS);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=PitVad(S,P,do,bn)
%
%Pitch and vad
HTh=0.60; %0.70 Harmonicity Threshold
SnrTh=3; %3 dB, SNR Thr
HFL=4;  %4 half filter length for pitch mean
Int=6/5; %6/5 pitch interval of search around mean ([1,2])

py=AcPitch(S.My,P,HTh,SnrTh,HFL,Int);
px=AcPitch(S.Mx,P,HTh,SnrTh,HFL,Int);

S.py=py; S.px=px;
[S.vad,S.GSNR]=VADPitHF(S.Fby,S.py,P.FricFact,P.HFSNRTh,P.ui,P.FLFr,P.MinMS); S.GSNR


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=NoiseMask(S,P,do)
%Noise and Mask
S.HarmVadMask=HarmVADMask(S.FbyCochl,S.Ay,S.py,S.vad,S.GSNR,P);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function WriteOutFiles(S,P,do,bn)
%Write Output

PS.y=S.y; 
PS.Fby=S.Fby; PS.Maskest=S.HarmVadMask; 
PS.py=S.py; PS.px=S.px; 
DemoPlotRes(PS,P)



S.Fby=AppDeltas(S.Fby,2,-1,'feat');
S.SMask=AppDeltas(S.HarmVadMask,2,-1,'mask');
WriteHTKF([do '/' bn '.Fby'], S.Fby, 1);
WriteHTKF([do '/' bn '.mask'], S.SMask, 1);
  
    
    
    
