function [rxs]=SiftMatlab(x,T,D)
%Rx Sifting
%In future: Compare r(0) with the SiftTonegram


N=length(x);


%Ini common index autoc matrix (not T dependend)
i=1:N;
mi=repmat(i',[1,N]);


mik=toeplitz(i);
j=triu(true(N,N),1); mi(j)=1; mik(j)=1;

%Ind (T depend)
Np=floor(N/T)+1;
i=mod(0:N-1,T)+1; ind=i(mi)+(i(mik)-1)*T;
[C,BBB0, BBB1]=ObtC(N,T,Np,D);

%Autocor (T & x depend)
pr=PrTab(x,T,Np,C,BBB0,BBB1);  
rx=sum(tril(pr(ind)))/N;

rxs=[rx(N:-1:2) rx];
%rxs=[rx];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function pr=PrTab(x,T,Np,C,BBB0,BBB1)
%Product table basic
P=zeros(1,Np*Np*T*T);
P(C)=x(BBB0(C)).*x(BBB1(C));     
C=reshape(C,Np*Np,T*T); ne=sum(C);
P=reshape(P,Np*Np,T*T); P(not(C))=0;    
a=sum(P)./ne;
pr=reshape(a,T,T);

function [C,BBB0, BBB1]=ObtC(N,T,Np,D)
%T dependt
b0=(0:Np-1)*T+1; %Np
B0=repmat(b0,[1 Np]); %Np*Np
BB0=repmat(B0,[1 T]); %Np*Np*T
vn=RepElem(0:T-1,Np*Np*T); 
BBB0=repmat(BB0,[1 T])+vn; %Np*Np*T*T              
b1=(0:Np-1)*T+1; %Np        
B1=RepElem(b1,Np); %Np*Np
vm=RepElem(0:T-1,Np*Np); 
BB1=repmat(B1,[1 T])+vm; %Np*Np*T     
BBB1=repmat(BB1,[1 T]); %Np*Np*T*T           
C=(abs(BBB0-BBB1)>=D & BBB1<=N & BBB0<=N);

function xr=RepElem(x,nr)
lx=length(x);
xr=reshape(repmat(x,[nr 1]),1,nr*lx);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%







