 
#include <stdio.h>
#include <stdlib.h> //For exit()
#include <string.h> //For strcpy
#include <math.h>
#include "../Common.h" // for HTK_Data_Frame
#include "../IO/fileio.h" 
#include "../Math/Math.h" 

const double BW_CORRECTION = 1.019;     // 4th Order gammatone

static double erb ( double x ) { return ( 24.7 * ( 0.00437 * x + 1.0 ) ); }
static double ErbRateToHz ( double x ) { return ( ( pow ( 10.0, ( x / 21.4 ) ) - 1.0 ) / 0.00437 ); }
static double HzToErbRate ( double x ) { return ( 21.4 * log10 ( 0.00437 * x + 1.0 ) ); }


// Gammatone filter
void gammatone ( double centre_freq, double* pdata_in, int nsamples, int sample_rate, float *floatout, double* pdata_out )
{
   int t;
   double a, tpt, tptbw, gain;
   double p0r, p1r, p2r, p3r, p4r, p0i, p1i, p2i, p3i, p4i;
   double a1, a2, a3, a4, a5, u0r, u0i;
   double qcos, qsin, oldcs, coscf, sincf;

  /************************************************************
   * Initialising variables
   ************************************************************/
   tpt = 2 * M_PI / sample_rate;
   tptbw = tpt * erb ( centre_freq ) * BW_CORRECTION;
   a = exp ( -tptbw );

   // based on integral of impulse response
   gain = tptbw * tptbw * tptbw * tptbw / 3;

   // Update filter coefficiants
   a1 = 4.0*a; a2 = -6.0*a*a; a3 = 4.0*a*a*a; a4 = -a*a*a*a; a5 = 4.0*a*a;
   p0r = 0.0; p1r = 0.0; p2r = 0.0; p3r = 0.0; p4r = 0.0;
   p0i = 0.0; p1i = 0.0; p2i = 0.0; p3i = 0.0; p4i = 0.0;
 
   coscf = cos( tpt * centre_freq );
   sincf = sin( tpt * centre_freq );
   qcos = 1; qsin = 0;
   for ( t = 0; t < nsamples; t++ )
   {
      // Filter part 1 & shift down to d.c.
      p0r = qcos * pdata_in[t] + a1 * p1r + a2 * p2r + a3 * p3r + a4 * p4r;
      p0i = qsin * pdata_in[t] + a1 * p1i + a2 * p2i + a3 * p3i + a4 * p4i;

      // Filter part 2
      u0r = p0r + a1*p1r + a5*p2r;
      u0i = p0i + a1*p1i + a5*p2i;

      // Update filter results
      p4r = p3r; p3r = p2r; p2r = p1r; p1r = p0r;
      p4i = p3i; p3i = p2i; p2i = p1i; p1i = p0i;
  
     /************************************************************
      * Basilar membrane response
      * 1/ shift up in frequency first
      * 2/ take the real part only
      ************************************************************/
      pdata_out[t] = ( u0r * qcos + u0i * qsin ) * gain;
      //if ( pdata_out[t] < 0 )
      //  pdata_out[t] = 0;  // half-wave rectifying

      floatout[t]=(float)(pdata_out[t]); 
	
      qcos = coscf * ( oldcs = qcos ) + sincf * qsin;
      qsin = coscf * qsin - sincf * oldcs;
   }
   
   return;
}





/////////////////////////////////////////////////////////////////////////////////////////////////////

/*Imput: 	x (float vector of speech)
Ouput:		do/bn.x (float x vector)
		do/bn.GammCh (32 Gamm filter results)*/

void Chan(float *xin, int nsamples, char *info)
{
	// Variables declaration
	int chan, i;
	double cf;	

	// Parameters
	int nchans = MELCH;	// number of channels
	double lowCF = 50.0;    // lowest centre frequency in Hz
   	double highCF = 3850.0; // highest centre frequency in Hz
	int winSize = 32;    	// ACG window size in millisecond
   	int frmShift = 10;   	// frame shift in ms
	int sample_rate = 8000; // Sample freq in Hz

	  // Parameter initialisation
   	int frameshift_samples = (int) roundf ( frmShift * sample_rate / (float) 1000 );
   	int _nframes = (int) ceil ( nsamples / (double) frameshift_samples );
   	int nsamples_padded = _nframes * frameshift_samples;
   	int winsize_samples = (int) roundf ( winSize * sample_rate / (float) 1000 );

	
	   // Padding signals
   	double* psignal_padded = malloc (nsamples_padded * sizeof (double));
   	for ( i = 0; i < nsamples; i++ ) psignal_padded[i] = (double) xin[i];
   	for ( i = nsamples; i < nsamples_padded; i++ ) psignal_padded[i] = 0.0;


	// ERB spacings
   	double lowErb = HzToErbRate ( lowCF );
   	double highErb = HzToErbRate (highCF );
   	double spaceErb = 0.0;
   	if ( nchans > 1 )  spaceErb = ( highErb-lowErb ) / ( nchans - 1 );


	// BM buffer for each channel
   	double* bmbuffer = malloc ((nsamples_padded + winsize_samples - frameshift_samples)* sizeof (double)) ;
   	for ( i = 0; i < winsize_samples - frameshift_samples; i++ )	bmbuffer[i] = 0;
   	

   	//FloatSamples outputs of each filterd channel  
   	float fout[nsamples];


	//Filtering
	for ( chan = 0; chan < nchans; chan++ ) 
	{
		cf = ErbRateToHz ( lowErb + chan * spaceErb );
		gammatone (cf, psignal_padded, nsamples, sample_rate, fout, bmbuffer + winsize_samples - frameshift_samples );	
		WriteCh (fout, nsamples, info, chan);
	}

	free(psignal_padded);
	free(bmbuffer);
}


//////////////////////////////////////////// SEGM CHANNELS ////////////////////////////////


int ReadSegmCh (float *x, int s, int lr, int lx, char *I, int ch);


void SegmCh(int nf, int ns, int L)
{
	
	int lr=(L-1)*FS+FL;
	int i, j, k, p, s, ch;
	float x[MELCH][lr], y[MELCH][lr];
	FrameChInformation FChI;

	
	for(i=0; i<nf; i=i+L)
	{
		if(i+L>=nf) L=nf-i;

		//Read x, y lr-Piece 		
		s=i*FS; lr=(L-1)*FS+FL;	

		for (ch=0; ch<MELCH; ch++)
		{
			ReadSegmCh (x[ch], s, lr, ns, "chx", ch);
			ReadSegmCh (y[ch], s, lr, ns, "chy", ch);
		}
		
		//Segm lr-Piece
		for(k=0; k<L; k++)
		{
			p=k*FS;
			
			for(ch=0; ch<MELCH; ch++)
			{
				for(j=0; j<FL; j++)
				{			
					FChI.chx[ch][j]=x[ch][p+j]; 
					FChI.chy[ch][j]=y[ch][p+j]; 
				}
			}

			Write1FChI(FChI, i+k);				
		}					
			
	}
	
	
}



void ChFilt(int ns)
{
	float s[ns];	

	//Load and Channeling x, y
	ReadCh(s, ns, "x", 0);
	Chan(s, ns, "chx");

	ReadCh(s, ns, "y", 0);
	Chan(s, ns, "chy");
}

/*Channel Filtering and Segmentation*/
void ChFiltSeg(int nf, int ns)
{

	ChFilt(ns);
	

			
	SegmCh(nf,ns,14);	

	
}






