 
#include <stdio.h>
#include <stdlib.h> //For exit()
#include <string.h> //For strcpy
#include "../Common.h" // for HTK_Data_Frame
#include "../IO/fileio.h" 




//////////////////////////////////////////////// VOICE CLASS //////////////////////////////////////////////////////////////////

//Find Unvoiced Sounds
void FUnvoic (unsigned char *vc, unsigned char *vcr, int nf)
{
	int L=5; //Middle word length
	int i, j, v, ini, fin;

	v=7;

	for(i=1; i<nf; i++)
	{
		//Case voice
		if(vc[i]=='3')
			v++;
			
		//Case final of voice
		if(vc[i]=='0'&&vc[i-1]=='3')
		{	
			//Left side
			ini=i-v-1-L; if(ini<0) ini=0;
			fin=i-v-1; if(fin<0) fin=0;					
								
			for(j=ini; j<=fin; j++)
			{			
				if(vc[j]=='0'&&vcr[j]!='0')
					vc[j]='1';
			}
			
			
			//Rigth side
			ini=i; if(ini>=nf) ini=nf;
			fin=i+L; if(fin>=nf) fin=nf;			
			
			for(j=ini; j<=fin; j++)
			{			
				if(vc[j]=='0'&&vcr[j]!='0')
					vc[j]='1';
			}
			v=0;
			
		}
	}	
}	

void FUnvoic2 (unsigned char *vc, unsigned char *vcr, int nf)
{
	int L=10; //Choosen to obtain most reallistic SNR Estimation
	int i, j;
	
	for(i=1; i<nf-1; i++)
	{
		if(vc[i]=='3'&&vc[i-1]=='0')
			{for(j=i-L; j<i; j++) {if(vcr[j]!='0'&& vc[j]!='3') vc[j]='1';}}
		
		if(vc[i]=='3'&&vc[i+1]=='0')
			{for(j=i+1; j<=i+L; j++) {if(vcr[j]!='0'&& vc[j]!='3') vc[j]='1';}}
	}
}

		
//Obtain vc is the first, before ObtPitch
//0: if no- or un- voiced
//3: if mix or total voiced 
void SmVc(unsigned char *vc, unsigned char *vcr, int nf)
{
	int MFL=7,  i, j, v, u;		
	
	//Smoothing with a mean filter
	for(i=0+(MFL-1)/2; i<nf-(MFL-1)/2; i++)
	{	
		
		v=0; u=0;
		//Find mean
		for(j=(i-(MFL-1)/2); j<=(i+(MFL-1)/2); j++)
		{
			if(vcr[j]=='3'||vcr[j]=='2') v++;
			else u++;
		}		
		
		//Subtitution
		if(v>=u) vc[i]='3';
		else vc[i]= '0';
	
	}
	
	

	//Egdes with '0'
	for(i=0; i<=(MFL-1)/2; i++)
		vc[i]='0';
	for(i=nf-(MFL-1)/2; i<nf; i++)
		vc[i]='0';	
	
	//Find Unvoiced
	//FUnvoic(vc, vcr, nf);
	FUnvoic2(vc, vcr, nf);

}

int Obt1VcSm(int nf)
{
	int i;
	unsigned char vcy[nf], vcry[nf], vcx[nf], vcrx[nf];
	FrameInformation FI;
	
	//Fill vcr
	for(i=0; i<nf; i++)
	{
		Read1FI(&FI, i);
		vcry[i]=FI.vcry;
		vcrx[i]=FI.vcrx;
	}
	
	//Smooth
	SmVc(vcy, vcry, nf);	
	SmVc(vcx, vcrx, nf);
	
	//Update FI
	for(i=0; i<nf; i++)
	{
		Read1FI(&FI, i);
		FI.vcy=vcy[i];
		FI.vcx=vcx[i];
		
		
		//printf("%c %c   \n", FI.vcrx, FI.vcx); 
		
		Write1FI(FI,i);
	}
	//getchar();

	
	return nf;

}

