
#include <stdio.h>
#include <stdlib.h> //For exit()
#include <string.h> //For strcpy
#include "../Common.h" // for HTK_Data_Frame
#include "../IO/fileio.h" 
#include "../Math/Math.h" 





//////////////////////////////////////////// PITCH MEAN ///////////////////////////////////////////////////////
//Pit mean FI
float PitMean(float *pr, int nf)
{
	float pitm=0.0;
	int i, cp=0;
		
	for(i=0; i<nf; i++)
	{		
		if (pr[i]>1)
		{
			pitm+=pr[i];			
			cp++;		
		}
	}	

	pitm=pitm/(float) cp;
	return pitm;
}

//P Histograma
float PHist(float *hist, float *p, int ini, int fin)
{
	int i, k;
	
	for (k=0; k<FL; k++)
		hist[k]=0;
	
	for(k=0; k<FL; k++)
	{
		for(i=ini; i<=fin; i++)
		{
			
			if((p[i]<=(float)k)&&(p[i]!=0))				
				hist[k]++;
		}	
	}	
	
	for (k=0; k<FL; k++)
		hist[k]=hist[k]/hist[FL-1];

	//Find 0.5 value
	for(k=0; k<FL; k++)
	{
		if(hist[k]>=0.5)
			return ((float)k);		
	}
	
	return -1;	

}

///////////////////////////////////////////// PITCH //////////////////////////////////////////////////////////////////
//Correct Pitch
float SmP(float *pm, float *rosa, float pr, unsigned char vc, float pmg)
{
	int i, ini, fin, posmax;	
	float max;
	
	if(vc=='3'||vc=='2')
	{	
		//See if pr is OK
		if(pr>(pmg*0.62) && pr<(pmg*1.6))
		{
			*pm=pr;
			return pr;	

		}	
		else
		{
			ini=(int) (*pm*0.8);
			fin=(int) (*pm*1.25);
	
			max=rosa[ini];
			posmax=ini;
	
			for(i=ini; i<=fin; i++)
			{
				if(rosa[i]>max)
				{
					max=rosa[i];
					posmax=i;		
				}	
			}
			
			*pm=0.7**pm+0.3*((float)posmax);
			return ((float)posmax);
		}		
	}
	else
		return 0.0;
					
		
} 

//Obtain Pitch
void Obt2PSm(int nf)
{
	int i;
	float pry[nf], pmgy, prx[nf], pmgx, hist[FL];
	float pmy, pmx;
	
	FrameInformation FI;
	
	//Read praw
	for(i=0; i<nf; i++)
	{
		Read1FI(&FI, i);
		pry[i]=FI.pry;
		prx[i]=FI.prx;	
	}

	//Pitch mean global
	pmgy=PHist(hist, pry, 0, nf-1);
	pmgx=PHist(hist, prx, 0, nf-1);
	

	//Smooth
	pmy=pmgy;
	pmx=pmgx;
	
	for(i=0; i<nf; i++)
	{
		Read1FI(&FI, i);
		
		FI.py=SmP(&pmy, &FI.rBy[FL-1], FI.pry, FI.vcy, pmgy);
		FI.px=SmP(&pmx, &FI.rBx[FL-1], FI.prx, FI.vcx, pmgx);	
		
		//printf("%2.0f %2.0f..........%2.0f %2.0f\n", FI.pry, FI.py, FI.prx, FI.px); getchar();

		Write1FI(FI, i);
	}



}



