#include <stdlib.h> //rand, abs, system 
#include <stdio.h> //fopen, printf 
#include <math.h> //sqrt, fabs, ceil
#include "../Math/Math.h"  //PIx2


//////////////////////////////////////////////////////// WINDOWS ////////////////////////////////////////////////////////////////// 
/*Triangle Win*/
void TriangWin (float *w, int l)
{
	int lim, n;
	
	if(l%2==0)
		lim=l/2-1;	
	else
		lim=(l-1)/2;

	for(n=0; n<=lim; n++)
	{
		w[n]=(float)(2*n)/(float)(l-1);
		w[l-1-n]=w[n];		
	}
	
}


/*Asymetric Triangle
w[-(Ll+1)]=0 and w[Lr+1)]=0, but in Ll and Lr is no zero
Ll=2, Lr=5, w= {0.0741  0.1481 0.2222 0.1852 0.1481 0.1111 0.0741 0.0370}
*/
void AsymTriangWin(float *w, int Ll, int Lr)
{
	int i;
	float n;

	//First Weight
	for(i=0; i<Ll; i++)
		w[i]=(float)(i+1)/(float)(Ll+1);
	w[Ll]=1;
	for(i=1; i<=Lr; i++)
		w[i+Ll]=(float)(Lr+1-i)/(float)(Lr+1);

	//Normalization
	n=SumV(w, (Ll+Lr+1));
	for(i=0; i<=Ll+Lr; i++)
		w[i]=w[i]/n;

}


/*Square Window*/
void SqWin(float *w, int tamw)
{
	int i;
	float v=1.0/(float)tamw;	

	for(i=0; i<tamw; i++)
		w[i]=v;
	
}

/*Hamming side + and -*/
void Hamming (float *win, int len)
{
    	int i;

    for (i = 0; i < len; i++)
        win[i] = 0.54 - 0.46 * cos (PIx2 * i / (len - 1));

}


/* Subf of WinDDRMov*/
void WinDDRWide(float *w, int a)
{
	int i, m;
	m = (int) ceil(((float)a)/2);
	float FloatCor[m];
		
	
		//Obtain DDR-240 in w
		Hamming(w, m);
		rxosa(FloatCor, w, m,'b'); 
	
		
		w[a-1]=0.0; //Fill w 239
		
		
		for (i=0; i<m; i++) //Fill w from 119 to 238 (in 119 = 1)
			w[i+m-1]=FloatCor[i]/FloatCor[0];
		
		for (i=0; i<m; i++)  //Fill w from 0 to 119 (in 119 = 1)
			w[i]=FloatCor[m-i-1]/FloatCor[0];

}

/* WinDDRMov 
wc: Width complete of window 
c: Center of Win
wd: Width of ddr
*/
void WinDDRMov(float *w, int wc, int c, int wd)
{
	int i, sh, max;
	float wDDR[wd];
	
	sh=(c+1)-(int)ceilf((float)wd/2.0);

	//Dynamic memory for waux
	max=wd; if (wd<wc) max=wc;
	float *waux = (float*)malloc(3*max * sizeof (float));
	Zeros(waux, 3*max);	


	//	
	WinDDRWide(wDDR, wd);	
			
	//
	for (i=0; i<wd; i++)
		waux[i+max+sh]=wDDR[i];		
	
	for(i=0; i<wc; i++)
		w[i]=waux[i+max];

	free(waux);		
	
}

///////////////////////////////////////////////////////// ROUND ///////////////////////////////////////////////////
float roundf(float f)
{
	float r = (float)((int) f);
	if((f-r)>0.5) return r+1.0;
	else return r;
	

}

int float2int(float f)
{
	int n= (int) f;
	float nf = (float) n;

	if ((f-nf) < (n+1-f))
		return n;
	else
		return n+1;
	
}

//////////////////////////////////////////////////////////////// RAND PERM /////////////////////////////////////////////////

//Vector of seed 
unsigned int vseed[256]={
0, 1481765933, 1085377743, 1270216262, 1191391529, 812669700, 553475508, 445349752,
1344887256, 730417256, 1812158119, 147699711, 880268351, 1889772843, 686078705, 2105754108,
182546393, 1949118330, 220137366, 1979932169, 1089957932, 1873226917, 715669847, 1486937972,
1196032868, 777206980, 68706223, 1843638549, 212567592, 1883488164, 964776169, 928126551,
1301950427, 1992516190, 1426542624, 849040635, 941604920, 1400427944, 1994719310, 2038269862,
659998484, 1280937363, 1681643301, 725914710, 1729267236, 2023351876, 142750431, 1840579929,
2098560397, 1910500675, 1170970491, 1856224190, 983059344, 1718458134, 1876268425, 1764841629,
398844030, 185252727, 1370429126, 502141743, 993687334, 15934104, 1363674760, 904629749,
2047965620, 451230256, 2084670932, 561035572, 1840531613, 1248402490, 1518954509, 614127119,
683337405, 1382875695, 1843654049, 1436430327, 951656719, 120033497, 1669566824, 1277092596,
219218649, 643287356, 2041654184, 1429623093, 2035222245, 1888581007, 1505099306, 807426509,
1317442754, 1853580352, 292425665, 944216783, 589638738, 401170801, 1086979690, 1225161330,
1444887337, 1339228195, 131636656, 1182095963, 1211082011, 1152299427, 223840042, 1287487106,
593400968, 735206212, 1589759001, 2069834510, 668882480, 808284658, 1201886571, 1014983331,
2086000814, 1361784847, 761170564, 801013197, 730103625, 5748438, 1576460931, 1267998018,
1287998487, 1883570151, 659169187, 28409913, 2145324179, 1148026995, 1783671750, 1994411750,
6364913, 968295562, 1559931134, 653962273, 2011243547, 241418521, 699304830, 261159140,
1968925557, 1891777678, 1928854726, 542938503, 1135550597, 2059320408, 521884893, 873213988,
2071339238, 1965117085, 1525440093, 212677188, 1484742720, 1852483211, 533958746, 583332387,
2080815710, 217079209, 913595887, 1931858668, 2002583103, 237123473, 1963071900, 825207674,
1700375105, 196796183, 706140952, 9984370, 1976151787, 1319159302, 442727410, 232021905,
578512110, 303305400, 1117157996, 1269950142, 471898585, 1343191860, 2114797047, 1152143924,
338685731, 1762321158, 1749675386, 634535219, 1114316400, 68043415, 772004055, 659481682,
54969874, 1580643061, 1957115006, 1948283602, 553189268, 1023689365, 209050470, 587136518,
1675026723, 1817376089, 333349106, 1185694319, 1783003130, 302247655, 1987818732, 585293993,
1182559974, 1041127595, 1716688810, 3823673, 1999845055, 98508730, 220256095, 1600558245,
747030705, 1575147694, 2145222948, 718559873, 348928353, 2109934474, 1377520760, 288380741,
1209526756, 401155644, 166723143, 1287531640, 2002183737, 905284679, 347176135, 934901149,
1163821529, 1198427210, 2070386607, 1003224417, 204255255, 646953787, 1182909373, 209707626,
134707445, 801884112, 79172, 509813595, 1114827153, 691055053, 2024505183, 607161717,
458914655, 1226846017, 553909176, 1899333077, 14238776, 819515399, 681350654, 1221792728,
631623002, 957482161, 1097905455, 501708870, 2133968316, 1107735694, 130019381, 1106757930};

//returns random number in range of 34 to 88
int gen_rand(int min, int max)
{
   int j;
   j = min + (int)( (float)(max-min) * rand() / ( RAND_MAX + 1.0 ) );
   return(j);
}


//Rand Vector. If amax=3 -> 0,1,2,3. If amax=4 -> 0,1,2,3,4
long ncs=0; //numb of call to seed
void RandV(int *va, int tv, int amax)
{
	int i;
	
	amax=amax+1;
	
	//Initia seed
	srand(vseed[ncs%256]);
	//srand(vseed[ncs%2*NARX]);	

	ncs++;
   
	//Fill out vector
       for(i = 0; i < tv; i++){
		va[i]=rand() % amax;
		//fprintf(stderr,"%d ", va[i]);
	}
		//getchar();

}



/*
If amax=3, then permuta 0,1,2,3*/
void RandPerm(int *perm, int amax)
{
	int i, j, ne, a, bag[amax+1];
	
	//Initial bag
	for(i=0; i<=amax; i++)
		bag[i]=i;
	
	for(ne=amax; ne>=0; ne--)
	{			
		//Take a position from bag
		a=rand()%(ne+1); 	
		perm[ne]=bag[a];
			
		//Delete a position from bag
		j=0;
		for(i=0; i<=ne; i++)
			if(i!=a){bag[j]=bag[i]; j++;}			
	}

}

/*Random two Ortog a Vectors
if amax=3 then posibles values are 0,1,2,3 
*/
void RandOrtV (int *a1, int *a2, int amax, int l)
{
	int i, p[amax+1];

	//Initia seed
	srand(vseed[ncs%256]);
	ncs++;
   
	//Find Vectors
	for(i=0; i<l; i++)
	{
		RandPerm(p, amax);
		a1[i]=p[0];
		a2[i]=p[amax];		
	}
}




/*Rand Periodic Permutation Vector
If Nper=4 -> 0,1,2,3. If Nper=5 -> 0,1,2,3,4*/
void RandPPV (int *va, int Nper, int T)
{
	int i, n, a[Nper];
	
	//Initia seed
	srand(vseed[ncs%256]);
	ncs++;

	//Find Vector
	for (n=0; n<T; n++)
	{
		RandPerm(a, Nper-1);	
		for(i=0; i<Nper; i++)
			va[n+T*i]=a[i];	
	}
}









