#include <stdio.h> //fopen, printf 
#include <stdlib.h> //rand, abs, system 
#include <sys/time.h> //timeval
#include <math.h> //sqrt, fabs, ceil

#include "../Common.h" 
#include "./Math.h"
#include "../IO/fileio.h"


////////////////////////////////////////////////////////// SIMPLE OPERATORS ////////////////////////////////////////////////////////////

/*Create array of all zeros*/
void Zeros(float *x, int lx)
{
	int i;
	for(i=0; i<lx; i++)
		x[i]=0.0;

}

/*Create array of all zeros*/
void Ones(float *x, int lx)
{
	int i;
	for(i=0; i<lx; i++)
		x[i]=1.0;

}



float SumV(float *v, int lv)
{	
	int i;
	float s=0.0;
		
	for(i=0; i<lv; i++)
		s+=v[i];

	return s;
}

/*Dot Product of 2 vectors*/
float Dot(float *va, float *vb, int lv)
{
	int i;
	float v[lv];

	for(i=0; i<lv; i++)
		v[i]=va[i]*vb[i];

	return SumV(v, lv);
}



void Sum2V(float *v, float *a, float *b, int lv)
{
	int i;
	for(i=0; i<lv; i++)
		v[i]=a[i]+b[i];
}


void Sub2V(float *v, float *a, float *b, int lv)
{
	int i;	
	for(i=0; i<lv; i++)
		v[i]=a[i]-b[i];
}



void CopyV(float *vo, float *vi, int lv)
{
	int i;	
	for(i=0; i<lv; i++)
		vo[i]=vi[i];

}


void ExtractV(float *vo, float *vi, int ini, int fin)
{
	int i;
	for(i=ini; i<=fin; i++)
		vo[i-ini]=vi[i];
}

/*Extract elementes which are betwen +-lo of the
center
li: length of in vector
lo: length of out vector (uselly 511)
*v0=*vi is able due to vo[] is written with higher vi[i]. 
*/
int CenterVlo(float *v, int lo, int li)
{

	int i, a, b;
	a=(li-lo)/2;
	b=a+lo-1;
	
	for(i=a; i<=b; i++)
		v[i-a]=v[i];
	
	return b-a+1;
}

/*max of floatvector*/
float MaxV(float *x, int lx)
{
	int i;
	float max=x[0];
	for(i=0; i<lx; i++)
		if(x[i]>max) max=x[i];
	
	return max;		
}

/*abs of a vector*/
void FabsV(float *vo, float *vi, int l)
{
	int i;
	for(i=0; i<l; i++)
		vo[i]=fabs(vi[i]);
}

/*Square Sum of a Vector*/
float SqSumV(float *x, int l)
{
	int i;
	float sumsq=0.0;
	
	for (i = 0; i < l; i++) sumsq += x[i]*x[i];
	return sumsq;
}


////////////////////////////////////////////////////////// COMPLICATED OPERATORS ////////////////////////////////////////
/*Mean of each column of a Matrix*/
void MeanM(float *mean, float *M, int nf, int nc)
{
	int i, j;
	
	for(j=0; j<nc; j++)
	{
		mean[j]=0.0;
		for(i=0; i<nf; i++)
			mean[j]+=M[i*nc+j];			
		mean[j]=mean[j]/(float)nf;
	}
} 


/*Variance and Mean of each column of a Matrix*/
void VarM(float *var, float *mean, float *M, int nf, int nc)
{
	int i, j;

	MeanM(mean, M, nf, nc);
	
	for(j=0; j<nc; j++)
	{
		var[j]=0.0;
		for(i=0; i<nf; i++)
			var[j]+=(M[i*nc+j]-mean[j])*(M[i*nc+j]-mean[j]);			
		var[j]=var[j]/(float)nf;
	}
} 

/*Multiply matrix by vector*/
void MultMV(float *vo, float *m, float *v, int lv)
{
	int i, j;
	

	for(i=0; i<lv; i++)
	{	
		vo[i]=0;
		for(j=0; j<lv; j++)
			vo[i]=vo[i]+m[i*lv+j]*v[j]; //m[i][j]
	}	
}



/*Mean Normalization of a Matrix*/
void MeanNormalMatrix (float *M, int nf, int nc)
{
	int i, j;
	float mean[nc];

	MeanM(mean, M, nf, nc);
	
	for (j=0; j<nc; j++)
	{
		for (i=0; i<nf; i++)
			M[i*nc+j]=M[i*nc+j]-mean[j];
	}
}

/*Var and Mean Normalization of a Matrix*/
void VarMeanNormalMatrix (float *M, int nf, int nc)
{
	int i, j;
	float var[nc], mean[nc];
	
	//Variance, Mean and Dispersion
	VarM(var, mean, M, nf, nc);		
	for (j=0; j<nc; j++)
		var[j]=sqrt(var[j]);
	
	//Normalization
	for (j=0; j<nc; j++)
	{
		for (i=0; i<nf; i++)
			M[i*nc+j]=(M[i*nc+j]-mean[j])/var[j];
	}
}

/*Smooth a vector*/
void SmoothV(float *vo, float *vi, int nf, int L, char kind)
{
	int i;
	float w[2*L+1], va[2*L+1];

	
	//Center
	if (kind=='t') AsymTriangWin(w, L, L);	
	if (kind=='s') SqWin(w, L+L+1);	
	for(i=L; i<nf-L; i++)
	{
		ExtractV(va, vi, i-L, i+L);
		vo[i]=Dot(va,w,L+L+1);
	}

	//Beggining		
	for(i=0; i<L; i++)
	{
		if (kind=='t') AsymTriangWin(w, i, L);
		if (kind=='s') SqWin(w, i+L+1);	
		ExtractV(va, vi, 0, i+L);
		vo[i]=Dot(va,w,i+L+1);
	}

	//Ending
	for(i=nf-L; i<nf; i++)
	{
		if (kind=='t') AsymTriangWin(w, L, nf-i-1);
		if (kind=='s') SqWin(w, L+nf-i+1);	
		ExtractV(va, vi, i-L, nf-1);
		vo[i]=Dot(va,w,L+nf-i+1);
	}
	

}

/*Smooth Matrix*/
void SmoothM (float *M, int nf, int nc, int L, char kind)
{
	int i, j;
	float vi[nf], vo[nf];
	
	for (j=0; j<nc; j++)
	{
		for (i=0; i<nf; i++)
			vi[i]=M[i*nc+j];
		
		SmoothV(vo, vi, nf, L, kind);	

		for (i=0; i<nf; i++)
			M[i*nc+j]=vo[i];		
	}
}

///////////////////////////////////////////// PHRASE OPERATIONS //////////////////////////////////////////////

/* Smoothed of a phrase information
nf: number of frames of the phrase 
nc: colums of the Information (CEPN, MELN)*/
void SmoothPI (char *I, int nf, int nc, int L, char kind)
{
	float M[nf][nc];

	DumpPI (&M[0][0], nf, nc, I);
	SmoothM(&M[0][0], nf, nc, L, kind);
	WritePI(&M[0][0], nf, nc, I);
}


/*Normalization of a phrase information
nf: number of frames of the phrase 
nc: colums of the Information (CEPN, MELN)*/
void NormalPI (char *I, int nf, int nc)
{
	float M[nf][nc];

	DumpPI (&M[0][0], nf, nc, I);
	MeanNormalMatrix(&M[0][0], nf, nc);
	WritePI (&M[0][0], nf, nc, I);
	
}

