#include <stdio.h> 
#include <stdlib.h>
#include <string.h>
#include <math.h>


#include "../Common.h"	
#include "../IO/fileio.h"



////////////////////////////////////////////// RECOGN /////////////////////////////////////////////////////

float DistV (float *v1, float *v2, int lv)
{
	int i;
	float d=0.0; float a;

	for (i=0; i<lv; i++)
	{
		a=v1[i]-v2[i];
		d+=sqrt(a*a);
	}

	return d/lv;
}

/*My Recognizer*/
void Recognizer (int nf)
{
	int i, nfs=0, nfv=0;
	float d, dg=0.0, ds=0.0, dv=0.0;
	FrameInformation FI;

	for(i=0; i<nf; i++)	
	{
		
		Read1FI(&FI, i);
		
		d=DistV(FI.CxEst, FI.Cx, CEPN);		
		
		dg+=d;
		if(FI.px<1.0) {ds+=d; nfs++;} 					
		else {		dv+=d;	nfv++;}
					
				
			
	}
	
	dg=dg/(float)nf;
	dv=dv/(float)nfv;
	ds=ds/(float)nfs;
	

	
	printf("Mean (%d) frame distance global:%0.f\n", nf, dg);
	printf("Mean (%d) frame distance voiced:%0.f\n", nfv, dv);
	printf("Mean (%d) frame distance silenc:%0.f\n", nfs, ds);
	

	
}

///////////////////////////////////////////////////////////////////////////////////

void OMask2(int nf)
{
	FrameInformation FI;
	int i, j;	
	float d; 
	
	
	for(i=0; i<nf; i++)	
	{		
		Read1FI(&FI, i);
		
		for (j=0; j<MELCH; j++)
		{
			d=FI.Fbx[j]-FI.Fby[j];						
			if(d>-1.0)	FI.om[j]=1.0;
			else 		FI.om[j]=0.0;											
		}		
		
		Write1FI(FI, i);	
	}

}

void OMask(int nf)
{
	FrameChInformation FChI;
	int i, j;	
	float d; 
	
	
	for(i=0; i<nf; i++)	
	{		
		Read1FChI(&FChI, i);
		
		for (j=0; j<MELCH; j++)
		{
			d=FChI.Echx[j]-FChI.Echy[j];
			//FChI.om[j]=d;
					
				
			if(d>-0.75)	FChI.om[j]=1.0;
			else 		FChI.om[j]=0.0;											
		}		
				
	
		Write1FChI(FChI, i);	
	}

}



void Mask (int nf)
{
	OMask(nf);
	//GetMaskCh (nf);
	
}

















