 
#include <stdio.h>
#include <stdlib.h> //For exit()
#include <string.h> //For strcpy
#include <math.h>
#include "../Common.h" // for HTK_Data_Frame
#include "../IO/fileio.h" 
#include "../Math/Math.h" 

#define ENERGYFLOOR_logE      -50.0  

float EnergyFloor_logE;

/////////////////////////////////////////////////// R0 /////////////////////////////////////

float BestPr (float *vpr, int lv)
{
	int i, Nav=0;
	float a=0.0;
	
	for (i=0; i<lv; i++)
	{	
		{a=a+vpr[i]; Nav++;}	
	}

	if (Nav>0 && a>0.0) a=(a/(float)Nav);	
	else a=0.0;
	
	//if (Nav>0 ) a=(a/(float)Nav);	
	//else a=0.0;

	return a;
}	


/*R0Sift, Sift Energy of a frame*/
float R0Sift(float *x, float M[FL][FL], int T, int Np, int D)
{
	int i, lv, p0, p1, b0, b1;	
	float a, prav[T], vpr[Np*Np];

	
	
	// Basic square table
	for (i=0; i<T; i++)
	{		
		lv=0;
		for(p0=0; p0<Np; p0++)
		{	
			b0=p0*T+i; 
			if(b0 <FL)
			{
				for(p1=0; p1<Np; p1++)
				{ 
					b1=p1*T+i; 
					if((abs(b0-b1)>=D)  && b1<FL) {vpr[lv]=M[b0][b1]; lv++;} 
				}
			}			
		}			
		prav[i]=BestPr(vpr,lv);			
	}
	
	
	//rx basic
	a=0.0;
	for(i=0; i<FL; i++)
		a+=prav[i%T];
	
	
	a=(a/(float)FL);	

	
		
	return (a);
			
}


float DiffR0Sift(float *R0, float *x, float pf, int D)
{
	float a, M[FL][FL];
	int i, j, T=(int) pf;

	//Matrix of product
	for (i=0; i<FL; i++)
	{
		for (j=0; j<=i; j++)
		{
			a=x[i]*x[j];
			M[i][j]=a;
			M[j][i]=a;
		}
	}


	a=1.0;
	if (pf <= 1.0) T=55; 
	
	a=R0Sift(x, M, T, 1+FL/T, D);
	
	return log(a);
		
}





/////////////////////////////////////////// LOG ENERGY ////////////////////////////////////////////////////////


/*Calculate LogE with Threshold of the sum of square*/
float LogEThr(float sumsq)
{
	float LogEnergy;
	
	//If the sum of square is very small the log is -50 else calculate the log
	if (sumsq < EnergyFloor_logE) 
		LogEnergy = ENERGYFLOOR_logE;
	else 
		LogEnergy = (float) log((double) sumsq);
		
	return LogEnergy;		
}

float logEClass(float *x)
{
	return LogEThr(SqSumV(x, FL));
}

/*
float logESift(float *x, float pf, int D)
{
	float sumsq, logE;
	int T,Np;
	
	T=float2int(pf); 
	if(T<=1) T=55;
	Np=1+FL/T;

	//sumsq=R0Sift(x, T, Np, FL, D);
	sumsq=0.0;
	
	logE=LogEThr((sumsq*(float)FL));
	
	if(logE<=1.0) logE=1.0;

	return logE;
		
}*/


void IniIntensity()
{ 	
	EnergyFloor_logE = (float) exp ((double) ENERGYFLOOR_logE);
}




///////////////////////////////////////////////////////////////////////////////////
void Intensity(int nf)
{	
	FrameInformation FI;
	int i; 
	

	IniIntensity();		


		
	for(i=0; i<nf; i++)
	{	
		Read1FI(&FI, i);	
		
		FI.logExEst=logEClass(FI.yof);	
		
		//FI.logEx=logEClass(FI.xof);
		//FI.logExpe=logEClass(FI.xpe);			
		//FI.logEx=SumSq(FI.xof, FL);	
		//FI.logExpe=SumSq(FI.xpe, FL);
		
		Write1FI(FI, i);
	}


	
		

	
		
	
	
}


