#include <stdio.h>
#include <sys/time.h> //for timeval
#include <stdlib.h>
#include <unistd.h>  // usleep()



//To print voices intensity
void PrintfVoice (int intensity)
{
	int i;
	for (i=0; i<=intensity; i++)
		printf("*");
	printf("%d\n", intensity);
	
	
}

//Substract two times mark 
long restaTiempo(struct timeval *tfin, struct timeval *tini){
   
	long tfinus = tfin->tv_sec*1000000+ tfin->tv_usec;
	long tinius = tini->tv_sec*1000000+ tini->tv_usec;
	
	return (tfinus-tinius);
}

//Time statistic
void TimeStatistic (struct timeval *tini, struct timeval *tfin, long imax)
{
	long i;
	long deltaus, max=0, min=1000000, sum=0;	
	
	for(i=1; i<imax; i++)
	{
		deltaus = restaTiempo(&tfin[i],&tini[i]);
		
		printf("%ld ", deltaus);
		if(deltaus<min){min=deltaus;}
		if(deltaus>max){max=deltaus;}
		sum+=deltaus;
	}
	
	printf("\nMin: %ld, Max: %ld, Ave: %ld\n\n", min, max, (sum/imax));	
	
}


/////////////////////////////////////////////////////////// MY PRINT ARRAYS /////////////////////////////////////////////////////////////
//Print a float Array (matrix (nf>1) o vetor (nf=1))
void PrintfFA (float *arr, int nf, int nc)
{

	int i, j;

	for(i=0; i<nf; i++)
	{
		for(j=0; j<nc; j++)
			printf("%.1f ", arr[i*nc+j]); //arr[i][j]
		printf("\n");
	}
	getchar();

}

//Print a int Array (matrix (nf>1) o vetor (nf=1))
void PrintfIA (int *arr, int nf, int nc)
{

	int i, j;

	for(i=0; i<nf; i++)
	{
		for(j=0; j<nc; j++)
			printf("%d ", arr[i*nc+j]); //arr[i][j]
		printf("\n");
	}
	getchar();

}


//Print a vector in a File
void PrintV (float *v, int tamv)
{
	int i;
	FILE *fp_aux=NULL; 
	
	fp_aux = fopen("FichAux.txt","w");
	
	fprintf(fp_aux,"\n ");
	for (i = 0; i < tamv; i++)
		fprintf(fp_aux,"%f \n", v[i]);
	fprintf(fp_aux,"\n ");
	
	fclose(fp_aux);
	fprintf(stderr,"Vector volcado en FichAux"); fflush(stderr);
	getchar();

}

//Print 3 vectors in a File
void Print3V (float *v1, float *v2, float *v3, int tamv)
{
	int i;
	FILE *fp_aux=NULL; 
	
	fp_aux = fopen("FichAux.txt","w");
	
	fprintf(fp_aux,"\n ");
	for (i = 0; i < tamv; i++)
		fprintf(fp_aux,"%f %f %f\n", v1[i],  v2[i],  v3[i]);
	fprintf(fp_aux,"\n ");
	
	fflush(fp_aux);	
	fclose(fp_aux);
	fprintf(stderr,"Vectores 3 volcados en FichAux"); fflush(stderr);
	getchar();
	//usleep(250000);



}








