//Input Output FILE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "../Common.h"  
#include "fileio.h"
#include "../Math/Math.h"  


#define STRL 1000

 
FILE *fp_fi = NULL; 
FILE *fp_ch = NULL;
FILE *fp_gi = NULL;
typedef struct HTK_Header{
                          unsigned int nSamples;
                          unsigned int sampPeriod;
                          unsigned short int sampSize;
                          unsigned short int sampKind;
                          }HTK_Header;

///////////////////////////////////////////////////// BASE NAME ///////////////////////////////////////////////////////////////
/*Base and Path name*/
void GetBaseName (char *bn, char *cad)
{
	char c, *cad1, *cad2;
	int i, i1, i2, l, l1, l2;
	
	//Find limits
	l=strlen(cad); 
	c='/'; cad1=strrchr(cad, c); l1=strlen(cad1); 
	c='.'; cad2=strrchr(cad, c); l2=strlen(cad2); 
	i1=l-l1+1;
	i2=l-l2;
	
	//Base name		
	for(i=i1; i<i2; i++)
		bn[i-i1]=cad[i];
	bn[i2-i1]='\0';
	
	//Path name
	//for(i=0; i<i1-1; i++)
	//	pn[i]=cad[i];
	//pn[i]='\0';
	
}

void GetFileName(char *o, char *pn, char *bn, char *ext)
{
	strcpy(o,pn);  
	strcat(o,"/"); 
	strcat(o,bn); 
	strcat(o,"."); 
	strcat(o,ext); 
}





///////////////////////////////////////////////////////////////////////////// FI //////////////////////////////////////////////////////////////////////////////////////////

//Analize input options 
void OpenFileInf()
{
	fp_fi =  tmpfile();
	fp_ch =  tmpfile();		
	fp_gi =  tmpfile();
	
}

/*Dump in a matrix phrase frames information
rows nf: I of different frames
colums nc: I */
void DumpPI (float *M, int nf, int nc, char *I)
{

	int i, j;
	FrameInformation FI;	

	for(i=0; i<nf; i++)	
	{
		Read1FI(&FI, i);		
		
		if 	(strcmp (I, "CxEst") == 0) 	{for(j=0; j<nc; j++)	M[i*nc+j]=FI.CxEst[j];}
		else if (strcmp (I, "Cx") == 0) 	{for(j=0; j<nc; j++)	M[i*nc+j]=FI.Cx[j];}
		else if (strcmp (I, "logExEst") == 0)   {for(j=0; j<nc; j++)	M[i*nc+j]=FI.logExEst;}
		else if (strcmp (I, "logEx") == 0) 	{for(j=0; j<nc; j++)	M[i*nc+j]=FI.logEx;}


		else					{printf("ERROR: Not exits this menber: %s\n", I);}			
	}
}

/*Write matrix of phare frames information
rows nf: I of different frames
colums nc: I */
void WritePI (float *M, int nf, int nc, char *I)
{

	int i, j;
	FrameInformation FI;	

	for(i=0; i<nf; i++)	
	{
		Read1FI(&FI, i);		
		
		if 	(strcmp (I, "CxEst") == 0) 	{for(j=0; j<nc; j++)	FI.CxEst[j]=M[i*nc+j];}
		else if (strcmp (I, "Cx") == 0) 	{for(j=0; j<nc; j++)	FI.Cx[j]=M[i*nc+j];}
		else if (strcmp (I, "logExEst") == 0)   {for(j=0; j<nc; j++)	FI.logExEst=M[i*nc+j];}
		else if (strcmp (I, "logEx") == 0) 	{for(j=0; j<nc; j++)	FI.logEx=M[i*nc+j];}


		else					{printf("ERROR: Not exits this menber: %s\n", I);}

		Write1FI(FI, i);
					
	}
}




//////////////////////////////////////////////////////////////////////////////////////////////

int Read1FI(FrameInformation *FI, int pos)
{		
	int o;
	
	long p = pos*sizeof(FrameInformation);	
	fseek(fp_fi, p, SEEK_SET);		
	o=fread(&FI->logEy, sizeof(FrameInformation), 1, fp_fi); 			
	//fseek (fp_fi, 0L, SEEK_SET);

	return o;

}	


int Write1FI(FrameInformation FI, int pos)
{		
	int o;
	
	long p = pos*sizeof(FrameInformation);	
	fseek(fp_fi, p, SEEK_SET);	
	o=fwrite(&FI.logEy, sizeof(FrameInformation), 1, fp_fi);	
	//fseek (fp_fi, 0L, SEEK_SET);

	return o;
}	

int Read1FChI(FrameChInformation *FChI, int pos)
{		
	int o;
	
	long p = pos*sizeof(FrameChInformation);	
	fseek(fp_ch, p, SEEK_SET);		
	o=fread(&FChI->logEy, sizeof(FrameChInformation), 1, fp_ch); 			
	//fseek (fp_fi, 0L, SEEK_SET);

	return o;

}	


int Write1FChI(FrameChInformation FChI, int pos)
{		
	int o;
	
	long p = pos*sizeof(FrameChInformation);	
	fseek(fp_ch, p, SEEK_SET);	
	o=fwrite(&FChI.logEy, sizeof(FrameChInformation), 1, fp_ch);	

	
	//fseek (fp_fi, 0L, SEEK_SET);

	return o;
}



int WriteCh (float *x, int lx, char *I, int ch)
{

	int o;
	
	if 	(strcmp (I, "y") == 0) 		ch=0; 	
	else if (strcmp (I, "x") == 0) 		ch=1;
	else if (strcmp (I, "n") == 0) 		ch=2;
	
	else if (strcmp (I, "chx") == 0) 	ch=ch+3;	
	else if	(strcmp (I, "chy") == 0) 	ch=MELCH+ch+3;	
	else printf("ERROR: Unknow ReadCh Info");
	 
	long p = ch*sizeof(float)*lx;	
	fseek(fp_gi, p, SEEK_SET);	
	o=fwrite(x, sizeof(float), lx, fp_gi);	
	//fseek (fp_fi, 0L, SEEK_SET);

	return o;
}


int ReadCh (float *x, int lx, char *I, int ch)
{

	int o;
		
	if 	(strcmp (I, "y") == 0) 		ch=0; 	
	else if (strcmp (I, "x") == 0) 		ch=1;
	else if (strcmp (I, "n") == 0) 		ch=2;
	
	else if (strcmp (I, "chx") == 0) 	ch=ch+3;
	else if	(strcmp (I, "chy") == 0) 	ch=MELCH+ch+3;	
	else printf("ERROR: Unknow ReadCh Info");
	
	long p = ch*sizeof(float)*lx;	
	fseek(fp_gi, p, SEEK_SET);	
	o=fread(x, sizeof(float), lx, fp_gi);	
	//PrintV (x, lx);
	//fseek (fp_fi, 0L, SEEK_SET);

	return o;
}


/*Read Segment Channel: s (start sample [0,ns-1]), lx (if 3, [0,1, 2])*/
int ReadSegmCh (float *x, int s, int lr, int lx, char *I, int ch)
{

	int o;
		
	if 	(strcmp (I, "y") == 0) 		ch=0; 	
	else if (strcmp (I, "x") == 0) 		ch=1;
	else if (strcmp (I, "n") == 0) 		ch=2;
	
	else if (strcmp (I, "chx") == 0) 	ch=ch+3;
	else if	(strcmp (I, "chy") == 0) 	ch=MELCH+ch+3;	
	else printf("ERROR: Unknow ReadCh Info");
	
	long p = (ch*lx+s)*sizeof(float); 		
	fseek(fp_gi, p, SEEK_SET);	
	o=fread(x, sizeof(float), lr, fp_gi);	
	//PrintV (x, lx);
	//fseek (fp_fi, 0L, SEEK_SET);

	return o;
}


/////////////////////////////////////////////////////////////////////////// WRITEFILE ////////////////////////////////////////////////////////////////////////////////77
void ReadHTKHeader (FILE *fp, int *nf, char *kind, int *lv)
{
    HTK_Header header;


  
    fseek (fp, 0L, SEEK_SET);
    fread (&header.nSamples, sizeof (long), 1, fp);
    fread (&header.sampPeriod, sizeof (long), 1, fp);
    fread (&header.sampSize, sizeof (short), 1, fp);
    fread (&header.sampKind, sizeof (short), 1, fp);
	
    *nf= header.nSamples;
    *lv = header.sampSize/4;    
    *kind=header.sampKind;
	

	
}

void WriteHTKHeader (FILE *fp, int nf, char *kind, int lv)
{
   	HTK_Header header;
		
	header.nSamples = nf;
   	header.sampPeriod = 100000;  // 10000.0 us (100 Hz)
	header.sampSize = lv*4;
	

	if(!strcmp(kind,"FBANK")) 	{header.sampKind = 7;}	
	else if(!strcmp(kind,"MFCC_0_E")){header.sampKind = 8262;}
	else if(!strcmp(kind,"USER"))	{header.sampKind = 9;}	
	else
		printf("\nERROR: Unknow header format: %s\n", kind);
	


    fseek (fp, 0L, SEEK_SET);
    fwrite (&header.nSamples, sizeof (long), 1, fp);
    fwrite (&header.sampPeriod, sizeof (long), 1, fp);
    fwrite (&header.sampSize, sizeof (short), 1, fp);
    fwrite (&header.sampKind, sizeof (short), 1, fp);
    fseek (fp, 0L, SEEK_END);
    
	
}


int ReadOutFileI(char *bn, char *diro, char *I)
{
	FILE *fp = NULL; 
	char khead, n[STRL];
	FrameInformation FI;
	int nf, lv, i;

	
	
	
	
	GetFileName(n, diro, bn, I);
	
	
	fp=fopen(n, "rb");
	
	
	
	ReadHTKHeader (fp, &nf, &khead, &lv);	
	
	


	if (strcmp (I, "pit") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fread(&FI.pit, sizeof(float), lv, fp); Write1FI(FI, i); }}
	
	


	if (strcmp (I, "My") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fread(&FI.My[0], sizeof(float), lv, fp); Write1FI(FI, i);}}	
	

	
	 

	return nf;
	
}

void WriteOutFileI(char *bn, char *diro, int nf, char *I, char *khead, int lv)
{
	
	FILE *fp = NULL; 
	FrameInformation FI;
	int i;		
	char n[STRL];
	float a=0; a++;


	GetFileName(n, diro, bn, I);
	fp=fopen(n, "wb");	
	WriteHTKHeader (fp, nf, khead, lv);

	if (strcmp (I, "CxlogExEst") == 0) 	
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.CxEst[0],sizeof(float),CEPN,fp); fwrite(&FI.logExEst,sizeof(float),1,fp);}}
	

	else if (strcmp (I, "Fbx") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.Fbx[0], sizeof(float), lv, fp);}}	
	else if (strcmp (I, "Fby") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.Fby[0], sizeof(float), lv, fp);}}
	else if (strcmp (I, "FbxEst") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.FbxEst[0], sizeof(float), lv, fp);}}
		


	else if (strcmp (I, "Sx") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.Sx[0], sizeof(float), lv, fp);}}
	else if (strcmp (I, "Sy") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.Sy[0], sizeof(float), lv, fp);}}
	else if (strcmp (I, "SxEst") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.SxEst[0], sizeof(float), lv, fp);}}
	

	else if (strcmp (I, "pxJ") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.px, sizeof(float), lv, fp);}}
	else if (strcmp (I, "pyJ") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.py, sizeof(float), lv, fp);}}
	else if (strcmp (I, "prxJ") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.prx, sizeof(float), lv, fp);}}

	else if (strcmp (I, "vcx") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); a=(float)(FI.vcx)-48.0; fwrite(&a, sizeof(float), lv, fp);}}	
	else if (strcmp (I, "vcy") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); a=(float)(FI.vcy)-48.0; fwrite(&a, sizeof(float), lv, fp);}}
	

	
	else if (strcmp (I, "logEx") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.logEx, sizeof(float), lv, fp);}}
	

	else if (strcmp (I, "logEy") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.logEy, sizeof(float), lv, fp);}}

	
	
	else if (strcmp (I, "rBy") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.rBy[0], sizeof(float), lv, fp);}}
	else if (strcmp (I, "rBx") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.rBx[0], sizeof(float), lv, fp);}}
	else if (strcmp (I, "rBn") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.rBn[0], sizeof(float), lv, fp);}}

	else if (strcmp (I, "rBxEst") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&FI.rBxEst[0], sizeof(float), lv, fp);}}



	else if (strcmp (I, "rn") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&rn[0], sizeof(float), lv, fp);}}		
	else if (strcmp (I, "rne") == 0)  
	{for(i=0; i<nf; i++){Read1FI(&FI, i); fwrite(&rne[0], sizeof(float), lv, fp);}}	

	else if (strcmp (I, "om") == 0) 
	{FrameChInformation FChI;
	for(i=0; i<nf; i++){Read1FChI(&FChI, i); fwrite(&FChI.om[0], sizeof(float), lv, fp);}}

	else if (strcmp (I, "Echx") == 0)  
	{FrameChInformation FChI;
	for(i=0; i<nf; i++){Read1FChI(&FChI, i); fwrite(&FChI.Echx[0], sizeof(float), lv, fp);}}	
	else if (strcmp (I, "Echy") == 0)  
	{FrameChInformation FChI;
	for(i=0; i<nf; i++){Read1FChI(&FChI, i); fwrite(&FChI.Echy[0], sizeof(float), lv, fp);}}


	else if (strcmp (I, "x") == 0)  
	{float *s; s=(float*) malloc(nf*sizeof(float));	ReadCh(s, nf, "x", 0); fwrite(s, sizeof(float), nf, fp); free(s);}	
	else if (strcmp (I, "y") == 0)  
	{float *s; s=(float*) malloc(nf*sizeof(float));	ReadCh(s, nf, "y", 0); fwrite(s, sizeof(float), nf, fp); free(s);}
	else if (strcmp (I, "n") == 0)  
	{float *s; s=(float*) malloc(nf*sizeof(float));	ReadCh(s, nf, "n", 0); fwrite(s, sizeof(float), nf, fp); free(s);}

	else if (strcmp (I, "Chx") == 0)  
	{
		int j, ch; 
		float x[FL];
		FrameChInformation FChI;		

		WriteHTKHeader (fp, nf*FS, khead, lv);

		for(i=0; i<nf; i++)
		{
			Read1FChI(&FChI, i);
			for(j=0; j<FS; j++)
			{
				for(ch=0; ch<lv; ch++) x[ch]=FChI.chx[ch][j];
				fwrite(x, sizeof(float), lv, fp);
			}				
		}		
				
	}	



	else	{printf("ERROR: Not exits this Information %s\n", I);}
		
	fclose(fp);

	//printf("Processed and Written: %d %d-Frames in %s \n", nf,lv, n);
}

void PrintfSomeOuts ()
{
	FrameInformation FI;
	int i, nv=5;
	
	for(i=0; i<nv; i++) 
	{
		Read1FI(&FI, i); 
		//PrintfFA (FI.ype, 1, 5);
		//PrintfFA (FI.rBxEst, 1, 5);
		//PrintfFA (&FI.py, 1, 1);
		//PrintfFA (&FI.logExEst, 1, 1);
		//PrintfFA (FI.SxEst, 1, 5);
		//PrintfFA (FI.FbxEst, 1, 5);				
		PrintfFA (FI.CxEst, 1, 5);	
		
	}
				
	
}


int ReadOutFiles(char *bn, char *diro)
{
	int nf;
	
	nf=ReadOutFileI(bn, diro, "pit");
	nf=ReadOutFileI(bn, diro, "My");

	return nf;
}


void WriteOutFiles(char *bn, char *diro, int nf, int ns)
{
		//WriteOutFileI(bn, diro, nf, "CxlogExEst", "MFCC_0_E", CEPN+1);						
		//WriteOutFileI(bn, diro, nf, "Fby", "FBANK", MELCH);	
		
		//WriteOutFileI(bn, diro, nf, "Echx", "FBANK", MELCH);
		//WriteOutFileI(bn, diro, nf, "Echy", "FBANK", MELCH);
	

		//WriteOutFileI(bn, diro, ns, "x", "USER", 1);
		//WriteOutFileI(bn, diro, ns, "y", "USER", 1);
		//WriteOutFileI(bn, diro, ns, "n", "USER", 1);
		
		//WriteOutFileI(bn, diro, nf, "pxJ", "USER", 1);
		//WriteOutFileI(bn, diro, nf, "pyJ", "USER", 1);
		
		//WriteOutFileI(bn, diro, nf, "vcx", "USER", 1);
		//WriteOutFileI(bn, diro, nf, "vcy", "USER", 1);
		
		
		WriteOutFileI(bn, diro, nf, "rBxEst", "USER", 2*FL-1);
		
		//WriteOutFileI(bn, diro, nf, "om", "USER", MELCH);
	    
		
		
		
	
		//PrintfSomeOuts ();

}


//Finalize 
void Finalize()
{	
	fclose(fp_fi);	
	fclose(fp_ch);	
	fclose(fp_gi);		
}

