#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "../Common.h"	

#include "../IO/fileio.h"
#include "../Math/Math.h"

int RxSift(float *rxav, float *x, float pf, int D, char bias, char osa);

float SpRBias(float *Sp, float *rB, float *w511)
{
	int j, lrx=256;
	float Spr[512];	
		
	
	lrx=CenterVlo(rB, 511, 2*FL-1); 	

	//PSD and SubSampling
	PSD(Spr, rB, w511, 512, 9, lrx, 'r');
	for(j=0; j<=SL; j++)
		Sp[j]=Spr[j*2];	

	
	
	return rB[(lrx-1)/2];
	
}

float SpSift (float *Sp, float *s, float pf, float *w, int D)
{
	int j, lrx=256;
	float r[4*FL], Spr[512];	
		
		

	if(pf<1.0) {pf=55; 	lrx=RxSift(r, s, pf, D, 'b','c');} 					
	else {			lrx=RxSift(r, s, pf, D, 'b','c');}	
	
	

	lrx=CenterVlo(r, 511, lrx); 
	

	//PSD and SubSampling
	PSD(Spr, r, w, 512, 9, lrx, 'r');	
	for(j=0; j<=SL; j++)
		Sp[j]=Spr[j*2];	

	return r[(lrx-1)/2];
	
}

void SpRSub(float *Sp, float *y, float *n, float *w)
{
	int j, lrx=256;
	float ry[2*FL+1], rn[2*FL+1], rx[2*FL+1], Spr[512];	
		
	xcorr(ry, y, y, FL, 'b'); 
	xcorr(rn, n, n, FL, 'b'); 	
	Sub2V(rx, ry, rn, 2*FL+1);


	//PSD and SubSampling
	PSD(Spr, rx, w, 512, 9, lrx, 'r');
	for(j=0; j<=SL; j++)
		Sp[j]=Spr[j*2];	
		
}





void SpHase (float *Sp, float *w, float *ry)
{
	int j;
	float Spr[512];	
		
	//PrintV (w, FL);	

	//PSD and SubSampling
	PSD(Spr, ry, w, 512, 9, FL, 'r');
	for(j=0; j<=SL; j++)
		Sp[j]=Spr[j*2];	

}

void SpX (float *Sp, float *y)
{
	int j;
	float w[FL], Spr[256];			
	
	Hamming (w, FL);
	PSD(Spr, y, w, 256, 8, FL, 'x');
	for(j=0; j<=SL; j++)
		Sp[j]=Spr[j];	

}

void SpHarmSift (float *Sp, float *y, float pf, int D)
{
	int j, lrx;
	float r[4*FL], w[FL], Sprh[256];			
	
	SqWin(w, FL);
	
	if (pf<=1.0) pf=55;
	
	
	
	lrx=RxSift(r, y, pf, D, 'u','c');
	CenterVlo(r, FL, lrx);
		
	//printf("%d ", p);		
	
	PSD(Sprh, r, w, 256, float2int(pf), FL, 'h');
	
	
	//PSD(Spr, y, w, 256, 8, FL, 'x');
	//Print3V (Sprh, Sprh, Spr, 256);
	
	
	for(j=0; j<=SL; j++)
		Sp[j]=(Sprh[j]);	

}







