#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "../Math/Math.h"  //PIx2


#include "../Common.h"	
#include "../IO/fileio.h"
#include "../Math/Math.h"


#define ENERGYFLOOR_FB        -50.0  /*0.0 */
#define NUM_CHANNELS             23
#define STARTING_FREQ_1        64.0  /*55.401825 */
#define NUM_CEP_COEFF            13  /* c1..c12 + c0 */


float  *pDCTMatrix, EnergyFloor_FB;
int cbin[MELCH+2];

float SpRBias(float *Sp, float *rB, float *w511); 
void SpHase (float *Sp, float *w, float *ry);

///////////////////////////////////////////////// MEL //////////////////////////////////////////////////

float Mel(float f)
{
	return 	2595*log10(1+f/700);
}

float InvMel(float M)
{
	return 700*(exp(M/2595*2.3026)-1);	
}

/*FFTL: n points 0-2pi*/
void Getcbin(int *cbin, float fstart, float fs, int FFTL, int nch)
{  
	int i;
	float fci;
	
		
	for(i=0; i<=nch+1; i++)
	{
		fci=InvMel(Mel(fstart)+i*(Mel(fs/2)-Mel(fstart))/(nch+1));
		cbin[i]=roundf(FFTL*fci/fs);	
		
		//printf("%d %f %d", i, fci, cbin[i]);	getchar();
	}	
	
}


void MelSp(float *M, float *Sp, int *cb, int nch)
{

	int i, k;
	float a,c;
	
	for(k=1; k<=nch; k++)
	{
		
		
				
		a=0.0;
		for(i=cb[k-1]; i<=cb[k]; i++)
		{	
			c=(float)(i-cb[k-1]+1)/(float)(cb[k]-cb[k-1]+1);
			a+=Sp[i]*c;
			//printf("%d ",i); 
			
		}
		for(i=cb[k]+1; i<=cb[k+1]; i++)
		{
			c=1.0-((float)(i-cb[k])/(float)(cb[k+1]-cb[k]+1));
			a+=Sp[i]*c;
			//printf("%d ",i);
			
		
		}
		
		//getchar();
		
		M[k-1]=a;			
		
	}
}





/////////////////////////////////////////////////////////////////////// DCT ///////////////////////////////////////////////////////////

/*---------------------------------------------------------------------------
 * FUNCTION NAME: InitDCTMatrix
 *
 * INPUT:
 *   NumCepstralCoeff
 *                Number of cepstral coeffficients
 *   NumChannels  Number of filter bank channels
 *
 * OUTPUT
 *   none
 *---------------------------------------------------------------------------*/
float *
InitDCTMatrix (int NumCepstralCoeff, int NumChannels)
{
    int i, j;
    float *Mx;

    /* Allocating memory for DCT-matrix */
    Mx = (float *) malloc (sizeof (float) * (NumCepstralCoeff - 1) *
			   NumChannels);

    /* Computing matrix entries */
    for (i = 1; i < NumCepstralCoeff; i++)
        for (j = 0; j < NumChannels; j++)
            Mx[(i - 1) * NumChannels + j] = cos (PI * (float) i /
						 (float) NumChannels
						 * ((float) j + 0.5));
    return Mx;
}






/*Ouput C (c1, ...., c12, c0)*/
void DCT (float *C, float *Fb, float *Mx, int NumCepstralCoeff, int NumChannels)
{
    int i, j;

    //Computing c1..c/NumCepstralCoeff-1/, storing result after the incoming data vector 
    for (i = 1; i < NumCepstralCoeff; i++)
    {
        C[i-1] = 0.0;
        for (j = 0; j < NumChannels; j++)
            C[i-1] += Fb[j] * Mx[(i - 1) * NumChannels + j];
    }

    //Computing c0, as the last element of output vector 
    C[NumCepstralCoeff-1] = 0.0;
    for (i = 0; i < NumChannels; i++)
        C[NumCepstralCoeff-1] += Fb[i];

    return;
}



void DoRoot(float *x, int lx, double a)
{
	int i;	
	
	for (i = 0; i < lx; i++)
	{		
			x[i] = (float)pow((double)x[i], a);		
			//printf("%f ", x[i]); getchar();
	}
}

void DoLog(float *x, int lx)
{
	int i;
	
	for (i = 0; i < lx; i++)
	{
    		if (x[i] < EnergyFloor_FB)
      			x[i] = ENERGYFLOOR_FB;
    		else
      			x[i] = (float) log ((double) x[i]);
	}
}


//////////////////////////////////////////////////////////////////////// FUNCTIONS ///////////////////////////////////////////////////////////////////


void SpMelCeps(float *C, float *Fb, float *S, float *r, float *w)
{

	 

	SpRBias(S,  r, w);	
	MelSp(Fb, S, cbin, MELCH);					
	DoLog(Fb, MELCH);		
	DCT (C, Fb, pDCTMatrix, CEPN, MELCH);
	
}

void MelCeps(float *C, float *Fb, float *S)
{
 	
	MelSp(Fb, S, cbin, MELCH);			
	DoLog(Fb, MELCH);		
	DCT (C, Fb, pDCTMatrix, CEPN, MELCH);
	
}


void Formants (int nf)
{
	float  w511[511];
	FrameInformation FI;
	int i;

	
	//Ini Formants	
	EnergyFloor_FB = (float) exp ((double) ENERGYFLOOR_FB);		
  	pDCTMatrix = InitDCTMatrix (CEPN, MELCH);	
	Getcbin(cbin, 64, 8000, SL*2, MELCH);
	
	
	//Sp Windowing
	WinDDRMov(w511, 511, 255, 511);


	//Cepstrum
	for(i=0; i<nf; i++)	
	{
		
		Read1FI(&FI, i);			
					
		SpMelCeps(FI.CxEst, FI.FbxEst, FI.SxEst, FI.rBxEst, w511);	
		
		
		//SpMelCeps(FI.Cy, FI.Fby, FI.Sy, FI.rBy, w511);							
		//SpMelCeps(FI.Cx, FI.Fbx, FI.Sx, FI.rBx, w511);							
		
		//printf("%f %f", FI.px, FI.pNing); getchar();
		
		Write1FI(FI, i);
	}
	



	NormalPI ("CxEst", nf, CEPN);	
	NormalPI ("logExEst", nf, 1);
	
	//Fin
	free(pDCTMatrix); 


}

/////////////////////////////////////////////////// CHANNELS /////////////////////////

void ECh(float *E, float chs[MELCH][FL])
{

	int ch;
	for(ch=0; ch<MELCH; ch++) 
		E[ch]=logf(SqSumV(chs[ch],FL));
}


void Formants2 (int nf)
{
	int i;
	FrameChInformation FChI;
	
	

	for(i=0; i<nf; i++)	
	{
		
		Read1FChI(&FChI, i);			
					
		ECh(FChI.Echx, FChI.chx);
		ECh(FChI.Echy, FChI.chy);				
								
		Write1FChI(FChI, i);	
	}

}
