#define SAMPLE_RATE (2*8000)	//Sample frequenzy in Hz 
#define FL       	2*256 	//FRAME LENGTH 30ms
#define FS            	2*80  	//FRAME SHIFT 10ms 
#define SL	 	128	//SPECTRUM LENGTH (from 0 to pi-1).Must be power of 2
#define MELCH		23	//MEL CHANNELS (23, 32, 40)
#define CEPN		13	//NUMBER OF CEPSTR COEF (13  /* c1..c12 + c0 */)


#define STRL 1000


float rn[FL];
float rne[FL];

//Frame Information
typedef struct FrameChInformation{
						float logEy;	//Log Energy clean

						float chx[MELCH][FL];
						float chy[MELCH][FL];	
						float Echx[MELCH];	
						float Echy[MELCH];

						float om[MELCH];


					}FrameChInformation;



typedef struct FrameInformation{
						float logEy;	//Log Energy clean
						
						float My[FL];	
						float pit;

						float logEx;	
						float logExEst;

						
						
														
						unsigned char vcy;	//voice class
						unsigned char vcry;	//voice class raw
						float py;		//pitch	
						float pry;		//pitch raw
						
						unsigned char vcx;	//voice class
						unsigned char vcrx;	//voice class raw
						float px;		//pitch	
						float prx;		//pitch raw
							
							
						float pNing;						

											

						float y[FL];	
						float yof[FL];	
						float ype[FL];	
					
						float x[FL];
						float xof[FL];
						float xpe[FL];
						
						float n[FL];	
						float nof[FL];		
						float npe[FL];				

					
											
						float rBx[2*FL-1];							
						float rBy[2*FL-1];
						float rBn[2*FL-1];

						float rBxEst[2*FL-1];					
											
								
						
						float rosay[FL];
						float rosax[FL];
						float rosan[FL];		

						float rx0;
						
																								
						float Sx[SL+1];//128+1 because MEL uses pi freq coef 
						float SxEst[SL+1];//128+1 because MEL uses pi freq coef 	
						float Sy[SL+1];//128+1 because MEL uses pi freq coef 			
					
						float m[MELCH];
						float om[MELCH];
						
						float Fbx[MELCH];
						float FbxEst[MELCH];		
						float Fby[MELCH];
												
									
						float Cx[CEPN];
						float CxEst[CEPN];
						float Cy[CEPN];	
										
						
											
						int nf; //n of frame
						}FrameInformation;	

						


int SegmPrepr(int *nsamp, char *rawy, char *rawx, char *bn, char *diro);
void ChFiltSeg(int nf, int ns);
int PitVc(char *fnoisy, char *fclean, char *bn, char *diro, int nf);
void MyPitExt(int nf);
void Noise(int nf,  char *Dn);
void Intensity(int nf);
void Formants (int nf);
void Mask (int nf);
int ReadOutFiles(char *bn, char *diro);
void WriteOutFiles(char *rawy, char *diro, int nf, int ns);
void Finalize();





				

