function [rxs]=RxSiftMatlab(x,T,D)
%Rx Sifting

N=length(x);
Np=floor(N/T)+1;

%Product table basic
pr=PrTab(x,T,Np,D);        

%Ind
ind=mod(0:N-1,T)+1;

%Autocorr
rxb=zeros(1,N);
for k=0:N-1
    i=k+1:N;
    rxb(k+1)=sum(pr(ind(i)+(ind(i-k)-1)*T))/(N);
end

rx=rxb; 
rxs=[rx(N:-1:2) rx];

%rxs=[rx];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function xr=RepElem(x,nr)
lx=length(x);
xr=reshape(repmat(x,[nr 1]),1,nr*lx);

function pr=PrTab(x,T,Np,D)
%Product table basic

N=length(x);

b0=(0:Np-1)*T+1; %Np
B0=repmat(b0,[1 Np]); %Np*Np
BB0=repmat(B0,[1 T]); %Np*Np*T
vn=RepElem(0:T-1,Np*Np*T); 
BBB0=repmat(BB0,[1 T])+vn; %Np*Np*T*T    
              
b1=(0:Np-1)*T+1; %Np        
B1=RepElem(b1,Np); %Np*Np
vm=RepElem(0:T-1,Np*Np); 
BB1=repmat(B1,[1 T])+vm; %Np*Np*T     
BBB1=repmat(BB1,[1 T]); %Np*Np*T*T        
        
%    
C=(abs(BBB0-BBB1)>=D & BBB1<=N & BBB0<=N);

P=zeros(1,Np*Np*T*T);
P(C)=x(BBB0(C)).*x(BBB1(C));
     
C=reshape(C,Np*Np,T*T); ne=sum(C);
P=reshape(P,Np*Np,T*T); P(not(C))=0; 
   
a=sum(P)./ne;
pr=reshape(a,T,T);
