function a=FESift(y, x, do, bn, P);
%Feature Extractor

%Parameters
P.FL=P.FSamp*P.FLSec; 
P.FS=P.FSamp*P.FSSec; 
P.N2pi=2^ceil(log2(P.FL*2)); 
P.win=WinDDRcw([2*P.FL-1 P.FL-1 2*P.FL-1]); %[511 255 511]
P.D=8;
P.MaPitHz   = 270; %Max Pitch (Hz) (270 Hz)
P.MiPitHz   = 80; %Min Pitch (Hz) (80 Hz)
P.MiPitL    = round(P.FSamp/P.MaPitHz);
P.MaPitL    = round(P.FSamp/P.MiPitHz);


%
S=SegPrepr(P,y,x);
S=Pit(S,y,x,do,P);
S=RxEstim(S,S.py,do,bn,P);
S=Formats(S,P);
WriteOutFiles(S,P,do,bn);
a=-1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=SegPrepr(P,ys,xs)
%Segmentations
S.y=ys(:,end);  S.y=OffPreEmph(S.y);
S.x=xs(:,end);  S.x=OffPreEmph(S.x);

[S.My nf]=Segmx(S.y,P.FL,P.FS);
[S.Mx nf]=Segmx(S.x,P.FL,P.FS);
S.nf=nf;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=Pit(S,y,x,do,P)
%
HTh=0.60; %0.70 Harmonicity Threshold
SnrTh=3; %3 dB, SNR Thr
HFL=4;  %4 half filter length for pitch mean
Int=6/5; %6/5 pitch interval of search around mean ([1,2])

%S.py=DTWPitch(y,P); S.px=DTWPitch(x,P);
S.py=AcPitch(S.My,P,HTh,SnrTh,HFL,Int); S.px=AcPitch(S.Mx,P,HTh,SnrTh,HFL,Int);

%plot(px), hold on, plot(py,'ro'), hold off, pause

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=RxEstim(S,py,do,bn,P)
%
s=py==0; py(s)=round(55*P.FSamp/8000);
S.Rxest=RxSift(S.My,py,P.D,S.y,S.x,do,bn,P);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=Formats(S,P)
%
S.Xest=Msd(S.Rxest,'rx',P.N2pi,P);
S.Fbxest=SmoothFreqCompr(S.Xest,P.NCH,P.FSamp,P.N2pi,P.MF);
S.Cxest=Fbank2Cepst(S.Fbxest,-1,P.CepL,0,1,0);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function WriteOutFiles(S,P,do,bn)
%Write Output

PS.y=S.y; PS.Cxest=S.Cxest; 
PS.py=S.py; PS.px=S.px; 
DemoPlotRes(PS,P)

S.Cxest=AppDeltas(S.Cxest,2,2,'feat');
WriteHTKF([do '/' bn '.Cxest'], S.Cxest, 1);


 

    
  
    
    
