function [a]=FEDTWPit(y, x, do, bn, P)
%Feature Extractor

%For Mel
P.FL=P.FSamp*P.FLSec; 
P.FS=P.FSamp*P.FSSec; 
P.N2pi=2^ceil(log2(P.FL*2));
P.win=hamming(P.FL); 

%For Pitch 
P.MaPitHz   = 270; %Max Pitch (Hz) (270 Hz)
P.MiPitHz   = 80; %Min Pitch (Hz) (80 Hz)
P.MiPitL  = round(P.FSamp/P.MaPitHz); %Min Pit Lag
P.MaPitL  = round(P.FSamp/P.MiPitHz);


%
S=SegmRepr(P,y,x);
S=Pit(S,P,do,bn);
a=-1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=SegmRepr(P,ys,xs)
%Segmentations and Representations
S.y=ys(:,end);  % S.y=OffPreEmph(S.y);
S.x=xs(:,end); S.n=S.y-S.x;
[S.My nf]=Segmx(S.y,P.FL,P.FS);
[S.Mx nf]=Segmx(S.x,P.FL,P.FS);
[S.Mn nf]=Segmx(S.n,P.FL,P.FS);
S.nf=nf;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=Pit(S,P,do,bn)
%
%Pitch and vad
HTh=0.60; %0.70 Harmonicity Threshold
SnrTh=3; %3 dB, SNR Thr
HFL=4;  %4 half filter length for pitch mean
Int=6/5; %6/5 pitch interval of search around mean ([1,2])


apy=AcPitch(S.My,P,HTh,SnrTh,HFL,Int);
apx=AcPitch(S.Mx,P,HTh,SnrTh,HFL,Int);

S.dpx=DTWPitch(S.x,P); 
S.dpy=DTWPitch(S.y,P); 


PS.y=S.y; 
PS.py=S.dpy; PS.px=S.dpx; 
DemoPlotRes(PS,P)


    
    
    
