function [a]=FEChime2(y, x, do, bn, P)
%Feature Extractor

%Parameters
P.FL=P.FSamp*P.FLSec; 
P.FS=P.FSamp*P.FSSec; 
P.win=hamming(P.FL); 
P.N2pi=2^ceil(log2(P.FL*2)); 
P.FranzSK=2; %Franz Signal Kind

%FE
S=Segment(P,y,x,do,bn);
S=YXN(S,P);
WriteOutFiles(S,do,bn,P);
a=-1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [S]=TakeExtInfo(S, do, bn, P)
%
%P.FranSD='/clusterFS/project/Chime/SPEECHDATA/EnhancedContMaskSpecCHIME_AAll';
P.FranSD='../../../SPEECHDATADemo/FranzEnhanceCHIME_25';

[p1, b1]=fileparts(do); [p2, b2]=fileparts(p1);
if((strcmp(b2,'TrainReverb')||strcmp(b2,'TrainNoisy'))&&(P.FranzSK~=5))
    id=b1(3:end); bn=['s' id '_' bn];
end
bbn=[P.FranSD '/' b2 '/' b1 '/' bn];
if (P.FranzSK==0)
    P.FranExt='Original';
elseif (P.FranzSK==1)
    P.FranExt='EnhancedBinMaskSpec.wav';
elseif(P.FranzSK==2)
    P.FranExt='EnhancedContMaskSpec.wav';
elseif(P.FranzSK==3)
    P.FranExt='EnhancedBinMaskMel.wav';
elseif(P.FranzSK==4)
    P.FranExt='EnhancedContMaskMel.wav';
else
    disp('ERROR: Unknow FranExt');
end
fn=[bbn P.FranExt];
if (P.FranzSK==0)
    S.xest=S.yo;     
else    
    [S.xest,Fs]=wavread(fn); 
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=Segment(P,ys,xs,do,bn)
%Segmentations
S.yo=ys(:,end);  
S=TakeExtInfo(S, do, bn, P); 
S.xest=OffPreEmph(S.xest);
[S.Mxest nf]=Segmx(S.xest,P.FL,P.FS); 
S.nf=nf; 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=YXN(S,P)
%Spectrum 
S.Xest=Msd(S.Mxest,'x',P.N2pi,P);
S.Fbxest=SmoothFreqCompr(S.Xest,P.NCH,P.FSamp,P.N2pi,P.MF);
S.Cxest=Fbank2Cepst(S.Fbxest,-1,P.CepL,0,1,0);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function WriteOutFiles(S,do,bn,P)
%Write Output

PS.y=S.yo; 
PS.xest=S.xest;
PS.Cxest=S.Cxest;
DemoPlotRes(PS,P)


S.Cxest=AppDeltas(S.Cxest,2,2,'feat');
WriteHTKF([do '/' bn '.Cxest'], S.Cxest, 1);







   
		






    
    
    
    
